package csbase.remote;

import csbase.logic.ObserverData;

/**
 * Interface que define as operaes implementadas pelas classes que notificam
 * observadores remotos.
 * 
 * @author Tecgraf
 * 
 * @see RemoteObserversNotificationManager
 */
public interface RemoteObserverNotifierInterface {
  /**
   * Verifica se um evento deve ser enviado para um observador.
   * 
   * @param observerData observador
   * @param event evento
   * @return <code>true</code> se o evento deve ser enviado para o observador
   */
  public boolean has2update(ObserverData observerData, Object event);

  /**
   * Trata uma exceo fatal ocorrida durante o envio de uma notificao. As
   * excees reportadas atravs desse mtodo so fatais no sentido de que o
   * objeto remoto no podem mais ser encontrado e nenhuma outra notificao
   * posterior ser enviada para ele.
   * 
   * @param observerData observador que gerou o erro
   * @param event evento que seria enviado
   * @param e exceo recebida
   */
  public void handleFatalError(ObserverData observerData, Object event,
    Exception e);

  /**
   * Trata uma exceo ocorrida durante o envio de uma notificao. As excees
   * reportadas atravs desse mtodo no so fatais, no sentido de que o objeto
   * remoto pode voltar a ser encontrado e outras notificaes posteriores podem
   * vir a ser enviadas para ele.
   * 
   * @param observerData observador que gerou o erro
   * @param event evento que seria enviado
   * @param e exceo recebida
   */
  public void handleException(ObserverData observerData, Object event,
    Exception e);

  /**
   * Informa se esse tratador est interessado em receber mensagens de log
   * referentes s operaes executadas pelo mecanismo de notificao remota.
   * 
   * @return true caso as mensagens devam ser geradas, false caso contrrio.
   */
  public boolean isLoggingNotifications();

  /**
   * Trata uma mensagem de log referente a alguma atividade de notificao.
   * Erros no so enviados para este mtodo, mas apenas mensagens contendo
   * informaes para auxlio  depurao.
   * 
   * @param msg A mensagem a ser inserida no log.
   */
  public void logNotification(String msg);
}