/*
 * $Id:$
 */
package csbase.logic;

import tecgraf.javautils.core.lng.LNG;

/**
 * Notificao de abertura de projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class ProjectRecoveryFailureNotification extends
  AbstractProjectRecoveryNotification {

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    String projectName = getProjectName();
    String ownerLogin = getOwnerLogin();
    String sufix = projectName + " (" + ownerLogin + ")";
    return LNG.get("csbase.logic.ProjectRecoveryFail") + sufix;
  }

  /**
   * Construtor
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param ownerId id do usurio dono do projeto.
   * @param projectName o nome do projeto.
   */
  public ProjectRecoveryFailureNotification(final String sender,
    final Object ownerId, final String projectName) {
    super(sender, ownerId, projectName);
  }
}
