package csbase.logic.algorithms.serializer.exception;

import tecgraf.javautils.core.lng.LNG;

/**
 * Exceco genrica lancada durante a serializaco ou deserializaco das
 * configuraces de um algortimo.
 * 
 * @author Tegraf / PUC-Rio
 */
public class AlgorithmConfigurationSerializerException extends Exception {
  public AlgorithmConfigurationSerializerException(Throwable cause) {
    super(createExceptionMessage(cause), cause);
  }

  private static String createExceptionMessage(Throwable cause) {
    if (null == cause.getMessage()) {
      return String.format(LNG.get(
    		  "csbase.logic.algorithms.serializer.SerializerException"),
    		  cause.getClass().getName());
    }
    else {
      return cause.getMessage();
    }
  }
}
