/*
 * $Id:$
 */

package csbase.exception.algorithms;

import csbase.exception.CSBaseException;
import tecgraf.javautils.core.lng.LNG;
/**
 * Exceo lanada pelo configurador de algoritmos quando uma operao  feita
 * sobre um parmetro que no existe.
 */
public final class ParameterNotFoundException extends CSBaseException {
  /**
   * Nome do parmetros no encontrados.
   */
  private final String[] parameterNames;

  /**
   * Construtor.
   * 
   * @param parameterName nome do parmetro
   */
  public ParameterNotFoundException(String parameterName) {
    this(new String[] { parameterName });
  }

  /**
   * Construtor.
   * 
   * @param parameterName nome do parmetro
   * @param algorithmDescription descrio do algoritmo
   */
  public ParameterNotFoundException(String parameterName,
    String algorithmDescription) {
    this(new String[] { parameterName }, algorithmDescription);
  }

  /**
   * Construtor.
   * 
   * @param paramNames nome dos parmetros
   */
  public ParameterNotFoundException(String[] paramNames) {
    super(LNG.get("ParameterNotFoundException.parameters_not_found"),
      makeParameterList(paramNames));
    this.parameterNames = paramNames;
  }

  /**
   * Construtor.
   * 
   * @param paramNames nome dos parmetros
   * @param algorithmDescription descrio do algoritmo
   */
  public ParameterNotFoundException(String[] paramNames,
    String algorithmDescription) {
    super(LNG.get("ParameterNotFoundException.parameters_not_found_in_algo"),
      makeParameterList(paramNames), algorithmDescription);
    this.parameterNames = paramNames;
  }

  /**
   * Monta uma string com uma lista de parmetros separadors por vrgula para a
   * mensagem de erro.
   * 
   * @param paramNames o nome dos parmetros.
   * @return a string com a lista de parmetros.
   */
  private static String makeParameterList(String[] paramNames) {
    StringBuilder builder = new StringBuilder();
    String separator = ", ";
    for (int i = 0; i < paramNames.length; i++) {
      builder.append(paramNames[i]);
      builder.append(separator);
    }
    builder.delete(builder.length() - separator.length(), builder.length());
    return builder.toString();
  }

  /**
   * Obtm um array de nomes dos parmetros no encontrados.
   * 
   * @return o nome dos parmetros
   */
  public String[] getParameterNames() {
    return parameterNames;
  }
}
