/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.IdInterface;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class IdFactory
implements Serializable {
    private int nextId;
    private List<Object> freeId;

    public IdFactory(List<? extends IdInterface> idInterfaces) {
        Collections.sort(idInterfaces, this.getComparator());
        this.freeId = new LinkedList<Object>();
        if (idInterfaces.size() == 0) {
            this.nextId = 0;
        } else {
            IdInterface idInterface = idInterfaces.get(0);
            int smallerId = (Integer)idInterface.getId();
            for (int t = 0; t < smallerId; ++t) {
                this.freeId.add(new Integer(t));
            }
            this.nextId = smallerId + 1;
            for (int i = 0; i < idInterfaces.size() - 1; ++i) {
                idInterface = idInterfaces.get(i);
                int id = (Integer)idInterface.getId();
                IdInterface idInterfaceNext = idInterfaces.get(i + 1);
                int idNext = (Integer)idInterfaceNext.getId();
                for (int j = id; j < idNext - 1; ++j) {
                    this.freeId.add(new Integer(j + 1));
                }
                this.nextId = idNext + 1;
            }
        }
    }

    public Object next() {
        if (this.freeId.size() == 0) {
            int current = this.nextId++;
            return new Integer(current);
        }
        return this.freeId.remove(0);
    }

    public void free(Object id) {
        this.freeId.add(id);
    }

    private Comparator<IdInterface> getComparator() {
        Comparator<IdInterface> idInterfaceComparator = new Comparator<IdInterface>(){

            @Override
            public int compare(IdInterface idInterface1, IdInterface idInterface2) {
                Integer id1 = (Integer)idInterface1.getId();
                Integer id2 = (Integer)idInterface2.getId();
                return id1.compareTo(id2);
            }
        };
        return idInterfaceComparator;
    }
}

