/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameterListener;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.EnumerationParameterValidator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import tecgraf.javautils.core.lng.LNG;

public final class EnumerationParameter
extends SimpleParameter<EnumerationItem> {
    public static final String TYPE = "ENUMERATION";
    private List<EnumerationItem> items;
    private transient List<EnumerationParameterListener> listeners = new LinkedList<EnumerationParameterListener>();
    private boolean mustSortItems;

    public EnumerationParameter(String name, String label, String description, EnumerationItem defaultValue, boolean isVisible, String commandLinePattern, List<EnumerationItem> items, boolean mustSortItems) {
        super(name, label, description, defaultValue, false, isVisible, commandLinePattern);
        if (items == null) {
            throw new IllegalArgumentException("items == null");
        }
        this.items = new ArrayList<EnumerationItem>(items);
        this.mustSortItems = mustSortItems;
        if (this.mustSortItems) {
            Collections.sort(this.items);
        }
    }

    public void addEnumerationParameterListener(EnumerationParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener == null");
        }
        this.listeners.add(listener);
    }

    @Override
    public Map<String, Object> exportValue() {
        HashMap<String, Object> parameterValues = new HashMap<String, Object>();
        EnumerationItem item = (EnumerationItem)this.getValue();
        if (item != null) {
            parameterValues.put(this.getName(), item.getId());
        }
        return parameterValues;
    }

    @Override
    public void importValue(Map<String, Object> parameterValues) {
        if (parameterValues == null) {
            throw new IllegalArgumentException("parameterValues == null");
        }
        String id = (String)parameterValues.get(this.getName());
        EnumerationItem item = this.getItem(id);
        if (item != null) {
            this.setValue(item);
        }
    }

    @Override
    public EnumerationItem getDefaultValue() {
        EnumerationItem item = (EnumerationItem)super.getDefaultValue();
        if (item == null) {
            return null;
        }
        if (item.isVisible()) {
            return item;
        }
        for (EnumerationItem anItem : this.getItems()) {
            if (!anItem.isVisible()) continue;
            return anItem;
        }
        return null;
    }

    @Override
    public Object getExpressionValue() {
        return null;
    }

    public EnumerationItem getItem(String id) {
        for (EnumerationItem item : this.items) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        return null;
    }

    public List<EnumerationItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getValueAsText() {
        EnumerationItem item = (EnumerationItem)this.getValue();
        if (item == null) {
            return null;
        }
        return item.getId();
    }

    public boolean setVisibleItem(String itemId, boolean isVisible) {
        EnumerationItem theItem = this.getItem(itemId);
        if (theItem == null) {
            return false;
        }
        if (theItem.isVisible() == isVisible) {
            return false;
        }
        theItem.setVisible(isVisible);
        if (this.getValue() == null || !((EnumerationItem)this.getValue()).isVisible()) {
            EnumerationItem newValue = null;
            for (EnumerationItem anItem : this.getItems()) {
                if (!anItem.isVisible()) continue;
                newValue = anItem;
                break;
            }
            this.setValue(newValue);
        }
        this.fireEnumerationItemWasSetVisible(theItem);
        return true;
    }

    @Override
    public void setValueAsText(String parameterValue) throws ParseException {
        EnumerationItem item;
        if (parameterValue == null) {
            item = this.getDefaultValue();
        } else {
            item = this.getItem(parameterValue);
            if (item == null) {
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parameters.EnumOutsiderIndex"), parameterValue, this, this.getItems());
            }
        }
        this.setValue(item);
    }

    boolean mustSortItems() {
        return this.mustSortItems;
    }

    @Override
    protected String getCommandValue(CommandLineContext context) {
        EnumerationItem item = (EnumerationItem)this.getValue();
        if (item == null) {
            return null;
        }
        return item.getCommandValue(context);
    }

    private void fireEnumerationItemWasSetVisible(EnumerationItem item) {
        for (EnumerationParameterListener listener : this.listeners) {
            listener.enumerationItemWasSetVisible(this, item);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new LinkedList<EnumerationParameterListener>();
    }

    public EnumerationParameterValidator createParameterValidator() {
        return new EnumerationParameterValidator(this.isOptional());
    }
}

