/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.exception.algorithms.FormulaCreationException;
import csbase.logic.algorithms.parameters.BooleanParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.IntegerParameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parameters.conditions.AndOperatorCondition;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.conditions.GenericCondition;
import csbase.logic.algorithms.parameters.conditions.NotOperatorCondition;
import csbase.logic.algorithms.parameters.conditions.OrOperatorCondition;
import csbase.logic.algorithms.parameters.conditions.SimpleCondition;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.LinkedList;
import tecgraf.javautils.core.lng.LNG;

public class ConditionParser {
    static final String CONDITION_ELEMENT = "condicao";
    static final String AND_ELEMENT = "e";
    static final String NOT_ELEMENT = "nao";
    static final String OR_ELEMENT = "ou";
    private static final String CONDITION_ELEMENT_PARAMETER_ATTRIBUTE = "parametro";
    private static final String CONDITION_ELEMENT_VALUE_ATTRIBUTE = "valor";

    public Condition loadCondition(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        String elementName = parser.getElementName();
        if (elementName.equals(CONDITION_ELEMENT)) {
            return this.loadConditionElement(parser, configurator);
        }
        if (elementName.equals(OR_ELEMENT)) {
            return this.loadOrCondition(parser, configurator);
        }
        if (elementName.equals(AND_ELEMENT)) {
            return this.loadAndCondition(parser, configurator);
        }
        if (elementName.equals(NOT_ELEMENT)) {
            return this.loadNotCondition(parser, configurator);
        }
        return null;
    }

    private Condition loadConditionElement(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        Object value;
        String expressionText = parser.getElementValue(null);
        if (expressionText != null) {
            try {
                return new GenericCondition(expressionText);
            }
            catch (FormulaCreationException e) {
                throw new ParseException(e, LNG.get((String)"csbase.logic.algorithms.parsers.ExpressionParsingError"), expressionText, e.getLocalizedMessage());
            }
        }
        String parameterName = parser.extractAttributeValue(CONDITION_ELEMENT_PARAMETER_ATTRIBUTE);
        SimpleParameter<?> parameter = configurator.getSimpleParameter(parameterName);
        if (parameter == null) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.ExpressionParsingError"), parameterName, CONDITION_ELEMENT, CONDITION_ELEMENT_PARAMETER_ATTRIBUTE);
        }
        if (parameter instanceof BooleanParameter) {
            value = new Boolean(parser.extractAttributeValueAsBoolean(CONDITION_ELEMENT_VALUE_ATTRIBUTE));
        } else if (parameter instanceof TextParameter) {
            value = parser.extractAttributeValue(CONDITION_ELEMENT_VALUE_ATTRIBUTE, null);
        } else if (parameter instanceof DoubleParameter) {
            value = parser.extractAttributeValueAsDouble(CONDITION_ELEMENT_VALUE_ATTRIBUTE, null);
        } else if (parameter instanceof IntegerParameter) {
            value = parser.extractAttributeValueAsInteger(CONDITION_ELEMENT_VALUE_ATTRIBUTE, null);
        } else if (parameter instanceof EnumerationParameter) {
            EnumerationParameter enumerationParameter = (EnumerationParameter)parameter;
            String itemId = parser.extractAttributeValue(CONDITION_ELEMENT_VALUE_ATTRIBUTE);
            EnumerationItem item = enumerationParameter.getItem(itemId);
            if (item == null) {
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.UndefinedConditionItem"), parameter, itemId);
            }
            value = item;
        } else {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.ParamNotAllowed"), parameter, "booleano", "texto", "real", "inteiro", "enumeracao");
        }
        parser.checkAttributes();
        parser.checkChildElements();
        return new SimpleCondition(parameter.getName(), value);
    }

    private AndOperatorCondition loadAndCondition(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        parser.checkAttributes();
        if (!parser.goToFirstChild()) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.UndefinedCondition"));
        }
        LinkedList<Condition> conditions = new LinkedList<Condition>();
        do {
            Condition condition;
            if ((condition = this.loadCondition(parser, configurator)) == null) continue;
            conditions.add(condition);
        } while (parser.goToNextSibling());
        if (conditions.size() < 2) {
            throw new ParseException(String.format(LNG.get((String)"csbase.logic.algorithms.parsers.OrMissingCondition"), conditions.size()));
        }
        AndOperatorCondition andOperatorCondition = new AndOperatorCondition(conditions);
        parser.goToParent();
        return andOperatorCondition;
    }

    private Condition loadNotCondition(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        parser.checkAttributes();
        if (!parser.goToFirstChild()) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.UndefinedCondition"));
        }
        Condition condition = this.loadCondition(parser, configurator);
        if (condition == null) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.UndefinedCondition"));
        }
        NotOperatorCondition notOperatorCondition = new NotOperatorCondition(condition);
        parser.goToParent();
        return notOperatorCondition;
    }

    private Condition loadOrCondition(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        parser.checkAttributes();
        if (!parser.goToFirstChild()) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.UndefinedCondition"));
        }
        LinkedList<Condition> conditions = new LinkedList<Condition>();
        do {
            Condition condition;
            if ((condition = this.loadCondition(parser, configurator)) == null) continue;
            conditions.add(condition);
        } while (parser.goToNextSibling());
        if (conditions.size() < 2) {
            throw new ParseException(String.format(LNG.get((String)"csbase.logic.algorithms.parsers.OrMissingCondition"), conditions.size()));
        }
        OrOperatorCondition orOperatorCondition = new OrOperatorCondition(conditions);
        parser.goToParent();
        return orOperatorCondition;
    }
}

