/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parsers.AbstractFileParameterParser;
import csbase.logic.algorithms.parsers.XmlParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

class InputFileListParameterParser
extends AbstractFileParameterParser<InputFileListParameter> {
    InputFileListParameterParser() {
    }

    @Override
    public InputFileListParameter createFileParameter(XmlParser parser, String name, String label, String description, boolean isOptional, boolean isVisible, String commandLinePattern, String[] types, FileParameterMode mode) throws ParseException {
        FileParameterPipeAcceptance usesPipe;
        boolean pipeDefined = parser.hasAttributeValue("permitir_pipe");
        if (pipeDefined && ((usesPipe = parser.extractAttributeValueAsEnumeration("permitir_pipe", new AbstractFileParameterParser.FileParameterPipeAcceptanceConverter())) == FileParameterPipeAcceptance.TRUE || usesPipe == FileParameterPipeAcceptance.ALWAYS)) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.NoPipesInputFile"));
        }
        boolean useRootDirectoryAsDefault = parser.extractAttributeValueAsBoolean("usar_diretorio_raiz_como_padrao", false);
        ArrayList<FileURLValue> defaultValue = null;
        if (useRootDirectoryAsDefault) {
            if (mode == FileParameterMode.REGULAR_FILE) {
                throw new ParseException("csbase.logic.algorithms.parsers.InputFileInvalidAttribute", "usar_diretorio_raiz_como_padrao");
            }
            defaultValue = new ArrayList<FileURLValue>();
            defaultValue.add(new FileURLValue(".", "DIRECTORY_TYPE"));
        }
        boolean mustSort = parser.extractAttributeValueAsBoolean("ordenar", true);
        boolean useFilter = parser.extractAttributeValueAsBoolean("usar_filtro", false);
        InputFileListParameter parameter = new InputFileListParameter(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern, types, mode, mustSort, useFilter);
        return parameter;
    }

    @Override
    public List<Class<? extends Parameter>> getParameterTypes() {
        return Collections.singletonList(InputFileListParameter.class);
    }

    @Override
    protected boolean acceptBothCategory() {
        return true;
    }
}

