/*
 * $Id: OpenProjectNotification.java 170738 2015-12-16 17:39:22Z fpina $
 */
package csbase.logic;

import tecgraf.javautils.core.lng.LNG;

/**
 * Notificao de abertura de projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class OpenProjectNotification extends Notification {

  /**
   * Nome do projeto.
   */
  private final String projectName;

  /**
   * Obtm o nome do projeto.
   * 
   * @return o nome
   */
  public String getProjectName() {
    return this.projectName;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isVolatile() {
    return false;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return LNG.get("csbase.logic.ProjectOpenNote") + projectName;
  }

  /**
   * Construtor
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param projectName o nome do projeto.
   */
  public OpenProjectNotification(String sender, String projectName) {
    super(sender);
    this.projectName = projectName;
  }
}
