/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.logic.algorithms.parameters;


/**
 * Parmetro Arquivo de Entrada.
 *
 * @author lmoreira
 */
public class InputFileParameter extends FileParameter {
  /** Texto que representa o tipo desse parmetro */
  public static final String TYPE = "INPUT_FILE";

  /** Indicador de que esse parmetro deve ser usado para carregar o valor de
   * outros parmetros.*/
  private boolean useToLoadParam = false;

  /**
   * Cria um parmetro do tipo arquivo de entrada.
   *
   * @param name O nome (No aceita {@code null}).
   * @param label O rtulo (No aceita {@code null}).
   * @param description A descrio do parmetro (No aceita {@code null}).
   * @param defaultValue O valor-padro (Aceita {@code null}).
   * @param isOptional Indica se o parmetro  opcional.
   * @param isVisible Indica se o parmetro deve ficar visvel.
   * @param commandLinePattern O padro para construo da linha de comando. O
   *        padro ser utilizado para escrever o trecho da linha do comando
   *        referente ao parmetro. Esta string ser passada para o mtodo
   *        MessageFormat.format(String,Object...). O primeiro formato ({0}) 
   *        referente ao nome e o segundo formato ({1})  referente ao valor. Se
   *        {@code null} o parmetro no produzir sada na linha de comando.
   * @param types O tipo do arquivo aceito.
   * @param mode O modo de funcionamento do parmetro. ou seleo simples
   *        {@code false}.
   * @param usesPipe Indica se este parmetro pode aceitar pipe
   *        {@link FileParameterPipeAcceptance#TRUE}, no aceita pipe
   *        {@link FileParameterPipeAcceptance#FALSE} ou *s* aceita pipe
   *        {@link FileParameterPipeAcceptance#ALWAYS}.
   * @param usesFilter Indica se um painel para filtro deve ser exibido.
   */
  public InputFileParameter(String name, String label, String description,
    FileURLValue defaultValue, boolean isOptional, boolean isVisible,
    String commandLinePattern, String[] types, FileParameterMode mode,
    FileParameterPipeAcceptance usesPipe, boolean usesFilter, boolean useToLoadParam) {
    super(name, label, description, defaultValue, isOptional, isVisible,
      commandLinePattern, types, mode, usesPipe, usesFilter, true);
    this.useToLoadParam = useToLoadParam;
  }

  /**
   * (non-Javadoc)
   *
   * @see csbase.logic.algorithms.parameters.SimpleParameter#getType()
   */
  @Override
  public String getType() {
    return TYPE;
  }

  /**
   *
   * {@inheritDoc}
   */
  @Override
  public boolean isOuput() {
    return false;
  }

  /**
   * Obtm o valor do atributo
   * {@value csbase.logic.algorithms.parsers.InputFileParameterParser#INPUT_FILE_PARAMETER_USE_TO_LOAD_PARAM }
   * @return
   */
  public boolean isUsedToLoadParam() { return this.useToLoadParam; }
}
