package csbase.logic.algorithms.parsers.triggers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.HideGroupTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.XmlParser;

/**
 * Fbrica de {@link HideGroupTrigger}.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class HideGroupTriggerFactory extends AbstractGroupTriggerFactory {
  /**
   * Cria a fbrica.
   */
  public HideGroupTriggerFactory() {
    super("ocultar_grupo", true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Trigger<?> doCreateTrigger(XmlParser parser, Condition condition,
    Parameter<?> parameter, SimpleAlgorithmConfigurator configurator)
      throws ParseException {
    ParameterGroup group = (ParameterGroup) parameter;
    return new HideGroupTrigger(group, condition);
  }
}
