package csbase.logic.diagnosticservice;

import java.io.Serializable;
import java.util.Map;

import csbase.logic.CommandFinalizationType;
import csbase.logic.algorithms.ExecutionType;

/**
 * Informaes estatsticas sobre a submisso de comandos.
 * 
 * @author Tecgraf PUC-Rio
 */
public class CommandExecutionStatisticsInfo implements Serializable {

  /**
   * Mapa com as estatsticas de submisso de comandos por tipo de comando
   */
  public final Map<ExecutionType, Integer> exeStats;

  /**
   * Nmero de execues de fluxos.
   */
  public final int flowStats;

  /**
   * Mapa com as estatsticas de submisso de comandos por algoritmo
   */
  public final Map<String, Integer> simpleAlgoExecutionStats;

  /**
   * Mapa com as estatsticas de submisso de comandos por fluxo de algoritmos.
   */
  public final Map<String, Integer> flowAlgoExecutionStats;

  /**
   * Mapa com o nmero de execues por usurio, independente do tipo.
   */
  public final Map<String, Integer> userExecutionStats;

  /**
   * Mapa com as estatsticas de execues por mquina (ns SGA).
   */
  public final Map<String, Integer> sgasExecutionStats;

  /**
   * Mapa com as estatsticas de execuo de algoritmos, por tipos de trmino de
   * execuo.
   */
  public final Map<CommandFinalizationType, Integer> simpleAlgoResultsStats;

  /**
   * Mapa com as estatsticas de execuo de fluxo, por tipos de trmino de
   * execuo.
   */
  public final Map<CommandFinalizationType, Integer> flowAlgoResultsStats;

  /**
   * Construtor.
   * 
   * @param exeStats mapa com as estatsticas de submisso de comandos por tipo
   *        de comando
   * @param flowStats nmero de execues de fluxos
   * @param simpleAlgoExecutionStats mapa com as estatsticas de submisso de
   *        comandos por algoritmo
   * @param flowAlgoExecutionStats mapa com as estatsticas de submisso de
   *        comandos por fluxo de algoritmos
   * @param userExecutionStats mapa com o nmero de execues por usurio,
   *        independente do tipo.
   * @param sgasExecutionStats mapa com as estatsticas de execues por mquina
   *        (ns SGA)
   * @param simpleAlgoResultsStats mapa com as estatsticas de execuo de
   *        algoritmos, por tipos de trmino de execuo
   * @param flowAlgoResultsStats mapa com as estatsticas de execuo de fluxo,
   *        por tipos de trmino de execuo
   */
  public CommandExecutionStatisticsInfo(Map<ExecutionType, Integer> exeStats,
    int flowStats, Map<String, Integer> simpleAlgoExecutionStats,
    Map<String, Integer> flowAlgoExecutionStats,
    Map<String, Integer> userExecutionStats,
    Map<String, Integer> sgasExecutionStats,
    Map<CommandFinalizationType, Integer> simpleAlgoResultsStats,
    Map<CommandFinalizationType, Integer> flowAlgoResultsStats) {
    this.exeStats = exeStats;
    this.flowStats = flowStats;
    this.simpleAlgoExecutionStats = simpleAlgoExecutionStats;
    this.flowAlgoExecutionStats = flowAlgoExecutionStats;
    this.userExecutionStats = userExecutionStats;
    this.sgasExecutionStats = sgasExecutionStats;
    this.simpleAlgoResultsStats = simpleAlgoResultsStats;
    this.flowAlgoResultsStats = flowAlgoResultsStats;
  }
}
