/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.exception.algorithms.FormulaCreationException;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.ValidationExpression;
import csbase.logic.algorithms.parsers.XmlParser;
import tecgraf.javautils.core.lng.LNG;

public class ValidationExpressionParser {
    static final String EXPRESSION_ELEMENT = "expressao";
    private static final String EXPRESSION_ELEMENT_ERROR_ATTRIBUTE = "erro";

    public void loadExpression(XmlParser parser, SimpleAlgorithmConfigurator configurator) throws ParseException {
        ValidationExpression expression;
        String errorMessage = parser.extractAttributeValue(EXPRESSION_ELEMENT_ERROR_ATTRIBUTE);
        String expressionText = parser.getElementValue(null);
        if (expressionText == null) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.MissingExprText"), EXPRESSION_ELEMENT);
        }
        parser.checkAttributes();
        parser.checkChildElements();
        try {
            expression = new ValidationExpression(configurator, expressionText, errorMessage);
        }
        catch (FormulaCreationException e) {
            throw new ParseException(e, e.getLocalizedMessage(), new Object[0]);
        }
        if (!configurator.addExpression(expression)) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.DuplcatedExprInAlgo"), expression, configurator);
        }
    }
}

