/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class ProjectSynchronizationResult
implements Serializable {
    private List<String> resultsA;
    private List<String> resultsB;
    private String message;
    private Throwable cause;
    private boolean success;

    public ProjectSynchronizationResult(String result, Throwable cause, List<String> resultsA, List<String> resultsB) {
        this.success = false;
        this.message = result;
        this.resultsA = resultsA;
        this.resultsB = resultsB;
        this.cause = cause;
    }

    public ProjectSynchronizationResult(List<String> resultsA, List<String> resultsB) {
        this.success = resultsA.size() + resultsB.size() <= 0;
        this.resultsA = resultsA;
        this.resultsB = resultsB;
    }

    public String getMessage() {
        return this.message;
    }

    public List<String> getResultsA() {
        return Collections.unmodifiableList(this.resultsA);
    }

    public List<String> getResultsB() {
        return Collections.unmodifiableList(this.resultsB);
    }

    public boolean succeeded() {
        return this.success;
    }

    public Throwable getCause() {
        return this.cause;
    }
}

