/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import java.io.Serializable;

public class MonitoredFile
implements Serializable {
    private static final String FORMAT_START = ":";
    private static final String FORMAT_SEPARATOR = ",";
    private static final String TEXT_TYPE = "TEXT";
    private String fileName;
    private String[] formats = new String[0];

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFormats() {
        return this.formats;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFormats(String[] formats) {
        this.formats = formats;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fileName).append(FORMAT_START);
        String sep = "";
        for (String type : this.formats) {
            sb.append(sep).append(type);
            sep = FORMAT_SEPARATOR;
        }
        return sb.toString();
    }

    public static MonitoredFile parseMonitoredFile(String s) {
        String[] split = s.split(FORMAT_START);
        String fileName = split[0];
        String[] formats = split.length > 1 ? split[1].split(FORMAT_SEPARATOR) : new String[]{TEXT_TYPE};
        MonitoredFile monitoredFile = new MonitoredFile();
        monitoredFile.setFileName(fileName);
        monitoredFile.setFormats(formats);
        return monitoredFile;
    }
}

