/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.elements.attributes;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parsers.elements.ParsedElement;
import csbase.logic.algorithms.parsers.elements.attributes.AbstractElementAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.StringToValueConverter;

public class IntegerAttribute
extends AbstractElementAttribute<Integer> {
    private IntegerAttribute minimumValueAttribute;
    private IntegerAttribute maximumValueAttribute;
    private Integer minimumValue;
    private Integer maximumValue;

    protected IntegerAttribute(String name, boolean isOptional, Integer defaultValue, IntegerAttribute defaultValueAttribute, Integer minimumValue, IntegerAttribute minimumValueAttribute, Integer maximumValue, IntegerAttribute maximumValueAttribute) {
        super(name, Integer.class, isOptional, defaultValue, defaultValueAttribute);
        this.minimumValue = minimumValue;
        this.maximumValue = maximumValue;
        this.minimumValueAttribute = minimumValueAttribute;
        this.maximumValueAttribute = maximumValueAttribute;
    }

    public IntegerAttribute(String name, Integer defaultValue, Integer minimumValue, Integer maximumValue) {
        this(name, true, defaultValue, null, minimumValue, null, maximumValue, null);
    }

    public IntegerAttribute(String name, Integer defaultValue) {
        this(name, defaultValue, null, null);
    }

    public IntegerAttribute(String name, Integer minimumValue, Integer maximumValue) {
        this(name, false, null, null, minimumValue, null, maximumValue, null);
    }

    public IntegerAttribute(String name) {
        this(name, null, null);
    }

    public void setMinimumValue(Integer minimumValue) {
        this.minimumValue = minimumValue;
    }

    public void setMaximumValue(Integer maximumValue) {
        this.maximumValue = maximumValue;
    }

    public void setMaximumValueAttribute(IntegerAttribute maximumValueAttribute) {
        this.maximumValueAttribute = maximumValueAttribute;
    }

    public void setMinimumValueAttribute(IntegerAttribute minimumValueAttribute) {
        this.minimumValueAttribute = minimumValueAttribute;
    }

    @Override
    public boolean validate(ParsedElement definition) throws ParseException {
        return super.validate(definition) && this.validateMaximum(definition) && this.validateMinimum(definition);
    }

    private boolean validateMinimum(ParsedElement definition) throws ParseException {
        Integer integerValue = (Integer)definition.getAttributeValue(this.getName());
        if (integerValue != null) {
            if (this.minimumValueAttribute != null) {
                this.minimumValue = (Integer)definition.getAttributeValue(this.minimumValueAttribute.getName());
            }
            if (this.minimumValue != null && integerValue < this.minimumValue) {
                throw new ParseException("O valor do atributo {1} est\u00e1 abaixo do valor m\u00ednimo permitido.\nValor encontrado: ({2}).\nValor m\u00ednimo: {3}.\n", this.getName(), integerValue, this.minimumValue);
            }
        }
        return true;
    }

    private boolean validateMaximum(ParsedElement definition) throws ParseException {
        Integer integerValue = (Integer)definition.getAttributeValue(this.getName());
        if (integerValue != null) {
            if (this.maximumValueAttribute != null) {
                this.maximumValue = (Integer)definition.getAttributeValue(this.maximumValueAttribute.getName());
            }
            if (this.maximumValue != null && integerValue > this.maximumValue) {
                throw new ParseException("O valor do atributo {1} est\u00e1 acima do valor m\u00e1ximo permitido.\nValor encontrado: ({2}).\nValor m\u00e1ximo: {3}.\n", this.getName(), integerValue, this.maximumValue);
            }
        }
        return true;
    }

    @Override
    public StringToValueConverter<Integer> getValueConverter() {
        return new StringToIntegerConverter();
    }

    private class StringToIntegerConverter
    implements StringToValueConverter<Integer> {
        private StringToIntegerConverter() {
        }

        @Override
        public Integer valueOf(String value) throws ParseException {
            Integer integerValue;
            if (value == null) {
                return null;
            }
            try {
                integerValue = new Integer(value);
            }
            catch (NumberFormatException e) {
                throw new ParseException(e, "O valor do atributo {1} deveria ser um n\u00famero inteiro.\nValor encontrado: ({2}).", IntegerAttribute.this.getName(), value);
            }
            return integerValue;
        }
    }
}

