/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.exception.CSBaseException;
import csbase.logic.MonitoredServerListener;
import csbase.logic.ObserverData;
import csbase.logic.ServerMonitor;
import csbase.logic.ServerMonitorListener;
import csbase.logic.ServerURI;
import csbase.logic.Session;
import csbase.remote.RemoteObservable;
import csbase.remote.RemoteObserver;
import csbase.remote.ServerEntryPoint;
import csbase.remote.ServiceInterface;
import csbase.util.rmi.IPingable;
import csbase.util.rmi.Pingable;
import java.lang.reflect.Field;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import tecgraf.javautils.core.lng.LNG;

public abstract class MonitoredServer
implements ServerMonitorListener {
    protected List<MonitoredServerListener> listeners;
    protected Map<String, List<ObserverData>> observers;
    protected Map<String, ServiceInterface> services;
    protected ServerMonitor monitor = null;
    protected Session session = null;
    protected AtomicBoolean alive = new AtomicBoolean(false);
    protected Class<?> locator;
    protected AtomicBoolean defaultServer = new AtomicBoolean(false);
    protected String systemName;
    protected String delegatedLogin = null;
    protected TimeZone timeZone = TimeZone.getDefault();
    private Thread reloginThread;
    protected Set<String> serviceNames;
    protected boolean ignoreVersion = false;
    private final boolean verbose;
    private int windowSize;
    public static final int RELOAD_TIME = 5;

    protected MonitoredServer(ServerURI serverURI, Class<?> locator, boolean ignoreVersion, int windowSize) {
        this(serverURI, locator, ignoreVersion, true, windowSize);
    }

    protected MonitoredServer(ServerURI serverURI, Class<?> locator, boolean ignoreVersion, boolean verbose, int windowSize) {
        if (serverURI == null) {
            throw new IllegalStateException("serverURI == null");
        }
        this.windowSize = windowSize <= 0 ? 5 : windowSize;
        this.verbose = verbose;
        this.locator = locator;
        this.monitor = new ServerMonitor(serverURI, 0, verbose);
        this.monitor.addListener(this);
        this.listeners = new ArrayList<MonitoredServerListener>();
        this.observers = new Hashtable<String, List<ObserverData>>();
        this.services = new Hashtable<String, ServiceInterface>();
        this.ignoreVersion = ignoreVersion;
    }

    protected MonitoredServer(ServerURI serverURI, Class<?> locator, int windowSize) {
        this(serverURI, locator, false, windowSize);
    }

    protected MonitoredServer(ServerURI serverURI, Set<String> serviceNames, boolean ignoreVersion, int windowSize) {
        this(serverURI, (Class)null, ignoreVersion, windowSize);
        this.serviceNames = serviceNames;
    }

    protected MonitoredServer(ServerURI serverURI, Set<String> serviceNames, int windowSize) {
        this(serverURI, (Class)null, false, windowSize);
        this.serviceNames = serviceNames;
    }

    protected final void setAsDefaultServer(boolean isDefaultServer) {
        if (this.defaultServer.get() != isDefaultServer) {
            this.defaultServer.set(isDefaultServer);
            if (this.isDefault() && this.isAlive()) {
                this.fillLocatorFields();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canReach(ServerURI uri, int port) throws RemoteException {
        Pingable pingable = new Pingable();
        UnicastRemoteObject.exportObject((Remote)pingable, port);
        try {
            boolean bl = this.monitor.getServer().canReach((IPingable)pingable);
            return bl;
        }
        finally {
            UnicastRemoteObject.unexportObject((Remote)pingable, true);
        }
    }

    private void startReloginThread(final ServerURI serverURI) {
        final int maxWinSize = this.windowSize;
        if (this.reloginThread == null || !this.reloginThread.isAlive()) {
            this.reloginThread = new Thread("reloginThread-" + serverURI){

                @Override
                public void run() {
                    int winSize = 1;
                    block3: while (true) {
                        try {
                            while (true) {
                                Thread.sleep(MonitoredServer.this.getNextTime(winSize));
                                if (MonitoredServer.this.validate()) {
                                    MonitoredServer.this.notifyConnectionReestablished(serverURI);
                                    break block3;
                                }
                                if (winSize >= maxWinSize) continue;
                                ++winSize;
                            }
                        }
                        catch (RemoteException e) {
                            System.err.println(LNG.get((String)"csbase.logic.CommunicationFail"));
                            continue;
                        }
                        catch (Throwable t) {
                            System.err.println(LNG.get((String)"csbase.logic.ReloginFail"));
                            t.printStackTrace();
                        }
                        break;
                    }
                }
            };
            this.reloginThread.start();
        }
    }

    private long getNextTime(int winSize) {
        return (long)((1.0 + Math.random() * Math.pow(2.0, winSize)) * 1000.0);
    }

    @Override
    public final void notifyServerReachable(ServerURI serverURI) {
        this.startReloginThread(serverURI);
    }

    @Override
    public final void notifyServerUnreachable(ServerURI serverURI) {
        this.alive.set(false);
        this.notifyConnectionLost(serverURI);
    }

    @Override
    public void notifyClientIPChanged(ServerURI serverURI) {
        try {
            if (this.isAlive()) {
                this.removeObservers();
                this.getMonitor().getServer().logout(this.session.getKey());
                this.notifyLoggedOut(serverURI);
            }
        }
        catch (RemoteException e) {
            System.err.println("Erro ao fazer o logout quando IP do cliente mudou.");
            e.printStackTrace();
        }
        finally {
            this.session = null;
            this.alive.set(false);
        }
        this.startReloginThread(serverURI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConnectionReestablished(ServerURI serverURI) {
        List<MonitoredServerListener> list = this.listeners;
        synchronized (list) {
            for (MonitoredServerListener l : this.listeners) {
                l.notifyConnectionReestablished(serverURI);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConnectionLost(ServerURI serverURI) {
        List<MonitoredServerListener> list = this.listeners;
        synchronized (list) {
            for (MonitoredServerListener l : this.listeners) {
                l.notifyConnectionLost(serverURI);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLoggedIn(ServerURI serverURI) {
        List<MonitoredServerListener> list = this.listeners;
        synchronized (list) {
            for (MonitoredServerListener l : this.listeners) {
                l.notifyLoggedIn(serverURI);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyLoggedOut(ServerURI serverURI) {
        List<MonitoredServerListener> list = this.listeners;
        synchronized (list) {
            for (MonitoredServerListener l : this.listeners) {
                l.notifyLoggedOut(serverURI);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addListener(MonitoredServerListener listener) {
        List<MonitoredServerListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void deleteListener(MonitoredServerListener listener) {
        List<MonitoredServerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public final synchronized boolean addObserver(String serviceName, RemoteObserver observer, Object arg) {
        if (!this.observers.containsKey(serviceName)) {
            this.observers.put(serviceName, new LinkedList());
        }
        List<ObserverData> observerList = this.observers.get(serviceName);
        observerList.add(new ObserverData(observer, arg));
        try {
            if (!this.isAlive()) {
                return false;
            }
            RemoteObservable remoteObservable = (RemoteObservable)((Object)this.services.get(serviceName));
            if (remoteObservable == null) {
                System.err.println(serviceName + LNG.get((String)"csbase.logic.ObserverAddFail"));
                return false;
            }
            remoteObservable.addObserver(observer, arg);
            return true;
        }
        catch (RemoteException ex) {
            this.monitor.invalidate();
            System.err.println(ex);
            return false;
        }
    }

    public final synchronized void deleteObserver(String serviceName, RemoteObserver observer, Object arg) {
        if (!this.observers.containsKey(serviceName)) {
            return;
        }
        List<ObserverData> observerList = this.observers.get(serviceName);
        ObserverData obsData = new ObserverData(observer, arg);
        observerList.remove(obsData);
        if (observerList.size() == 0) {
            this.observers.remove(serviceName);
        }
        this.removeObserver(serviceName, observer, arg);
    }

    private synchronized void removeObserver(String serviceName, RemoteObserver observer, Object arg) {
        if (!this.monitor.isReachable()) {
            System.err.println(LNG.get((String)"csbase.logic.OffLineWhenRemoving") + observer);
            return;
        }
        try {
            RemoteObservable remoteObservable = (RemoteObservable)((Object)this.services.get(serviceName));
            remoteObservable.deleteObserver(observer, arg);
        }
        catch (RemoteException e) {
            this.monitor.invalidate();
            System.err.println(e);
        }
    }

    private void printInfo(String msg) {
        if (this.verbose) {
            System.out.println(msg);
        }
    }

    protected final synchronized void sendObservers() {
        if (this.observers.isEmpty()) {
            this.printInfo(LNG.get((String)"csbase.logic.EmptyObserverList"));
            return;
        }
        for (String serviceName : this.observers.keySet()) {
            this.printInfo(LNG.get((String)"csbase.logic.SendObserver") + serviceName);
            List<ObserverData> observerList = this.observers.get(serviceName);
            RemoteObservable remoteObservable = (RemoteObservable)((Object)this.services.get(serviceName));
            if (remoteObservable == null) {
                String msg = serviceName + LNG.get((String)"csbase.logic.ObserverAddFail");
                System.err.println(msg);
                continue;
            }
            this.printInfo("MonitoredServer: " + observerList.size() + LNG.get((String)"csbase.logic.Observers"));
            for (ObserverData obsDat : observerList) {
                try {
                    remoteObservable.addObserver(obsDat.observer, obsDat.arg);
                }
                catch (Exception ex) {
                    this.monitor.invalidate();
                    System.err.println(ex);
                }
            }
        }
    }

    public void invalidate() {
        if (this.monitor == null) {
            return;
        }
        if (!this.isAlive()) {
            return;
        }
        if (this.monitor.tryReaching()) {
            Iterator<ServiceInterface> iter = this.services.values().iterator();
            if (!iter.hasNext()) {
                return;
            }
            ServiceInterface anyService = iter.next();
            try {
                anyService.getName();
            }
            catch (RemoteException e) {
                this.alive.set(false);
                this.notifyConnectionLost(this.monitor.getURI());
                this.startReloginThread(this.monitor.getURI());
            }
        } else {
            this.monitor.invalidate();
        }
    }

    protected boolean validate() throws CSBaseException, RemoteException {
        this.session = this.performLogin();
        if (this.session != null) {
            if (this.fetchServices()) {
                this.alive.set(true);
                if (this.isDefault()) {
                    this.fillLocatorFields();
                }
                this.sendObservers();
                this.setSystemNameOnServer();
                this.printInfo(String.format(LNG.get((String)"csbase.logic.LoggedIn"), this.monitor.getURI()));
                this.postLogin();
            } else {
                this.session = null;
                this.alive.set(false);
                System.err.println(String.format(LNG.get((String)"csbase.logic.LogInFail"), this.monitor.getURI()));
            }
        } else {
            this.alive.set(false);
        }
        return this.session != null;
    }

    private void setSystemNameOnServer() throws RemoteException {
        if (this.systemName != null) {
            this.monitor.getServer().setSystemName(this.session.getKey(), this.systemName);
        }
    }

    protected void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    protected abstract Session performLogin() throws CSBaseException, RemoteException;

    protected abstract void postLogin() throws CSBaseException;

    protected abstract String lng(String var1);

    protected final void flush() {
        try {
            this.logout();
            this.monitor = null;
            this.listeners.clear();
            this.observers.clear();
            this.listeners = null;
            this.observers = null;
            this.services = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected final void logout() {
        try {
            if (this.isAlive()) {
                this.removeObservers();
                this.monitor.getServer().logout(this.session.getKey());
                this.notifyLoggedOut(this.getURI());
                this.printInfo(String.format(LNG.get((String)"csbase.logic.LoggedOut"), this.getURI()));
            }
        }
        catch (Exception e) {
            System.err.println(LNG.get((String)"csbase.logic.LogOutError"));
            e.printStackTrace();
        }
        finally {
            this.monitor.stopMonitoring();
            this.session = null;
            this.alive.set(false);
        }
    }

    protected final boolean login() throws CSBaseException, RemoteException {
        if (!this.isAlive() && !this.monitor.lookup()) {
            String m = MessageFormat.format(this.lng("MonitoredServer.server_down"), this.getURI());
            throw new CSBaseException(m);
        }
        if (this.validate()) {
            this.notifyLoggedIn(this.getURI());
            this.monitor.startMonitoring();
            return true;
        }
        return false;
    }

    protected boolean fetchServices() throws CSBaseException, RemoteException {
        if (this.session == null) {
            throw new CSBaseException(MessageFormat.format(this.lng("MonitoredServer.nullsession"), this.getURI()));
        }
        this.services = this.getMonitor().getServer().fetchServices(this.session.getKey(), this.getServicesNames());
        return this.services != null && this.services.size() > 0;
    }

    protected final synchronized void removeObservers() {
        for (String serviceName : this.observers.keySet()) {
            List<ObserverData> observerList = this.observers.get(serviceName);
            RemoteObservable remoteObservable = (RemoteObservable)((Object)this.services.get(serviceName));
            for (ObserverData oa : observerList) {
                try {
                    remoteObservable.deleteObserver(oa.observer, oa.arg);
                }
                catch (RemoteException e) {
                    this.monitor.invalidate();
                    System.err.println(e);
                }
            }
        }
        this.observers.clear();
    }

    protected final boolean isAlive() {
        return this.alive.get();
    }

    protected final boolean isDefault() {
        return this.defaultServer.get();
    }

    protected final ServerMonitor getMonitor() {
        return this.monitor;
    }

    protected final Session getSession() {
        return this.session;
    }

    protected final ServerURI getURI() {
        return this.getMonitor().getURI();
    }

    protected final void fillLocatorFields() {
        if (this.locator == null) {
            return;
        }
        this.setValueOnLocatorField(ServerEntryPoint.class, this.monitor.getServer());
        for (String serviceName : this.services.keySet()) {
            ServiceInterface service = this.services.get(serviceName);
            Class<?> serviceInterface = this.getServiceInterface(service, serviceName);
            this.setValueOnLocatorField(serviceInterface, service);
        }
    }

    private Class<?> getServiceInterface(Object service, String serviceName) {
        Class<?>[] interfaces = service.getClass().getInterfaces();
        String fieldName = "SERVICE_NAME";
        for (int i = 0; i < interfaces.length; ++i) {
            Field f = null;
            try {
                f = interfaces[i].getField("SERVICE_NAME");
                if (!serviceName.equals(f.get(null))) continue;
                return interfaces[i];
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (IllegalAccessException e) {
                IllegalStateException ise = new IllegalStateException(MessageFormat.format(LNG.get((String)"csbase.logic.FailFieldAccess"), "SERVICE_NAME", interfaces[i].getName()));
                ise.initCause(e);
                throw ise;
            }
        }
        return null;
    }

    private boolean setValueOnLocatorField(Class<?> fieldType, Object value) {
        Field[] fields = this.locator.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getType().isAssignableFrom(fieldType)) continue;
            try {
                fields[i].set(null, value);
                return true;
            }
            catch (IllegalAccessException e) {
                IllegalStateException ise = new IllegalStateException(MessageFormat.format(LNG.get((String)"csbase.logic.FailFieldAccess"), fields[i].getName(), this.locator.getName()));
                ise.initCause(e);
                throw ise;
            }
        }
        return false;
    }

    protected Set<String> getServicesNames() {
        if (this.locator == null) {
            return this.serviceNames;
        }
        HashSet<String> servicesNames = new HashSet<String>();
        Field[] fields = this.locator.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!ServiceInterface.class.isAssignableFrom(fields[i].getType())) continue;
            try {
                Class<?> aServiceInterface = fields[i].getType();
                String serviceName = (String)aServiceInterface.getField("SERVICE_NAME").get(null);
                servicesNames.add(serviceName);
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return servicesNames;
    }

    public void setDelegatedLogin(String delegatedLogin) {
        this.delegatedLogin = delegatedLogin;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone != null) {
            this.timeZone = timeZone;
        }
    }
}

