/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;
import csbase.logic.algorithms.parameters.ExpressionFunction;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.TableParameter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public abstract class TableExpressionFunction
extends ExpressionFunction {
    public TableExpressionFunction(String name, Class<?> ... parameterTypes) {
        super(name, TableExpressionFunction.createParameterTypes(parameterTypes));
    }

    protected abstract Object doOperation(List<Object> var1, Object ... var2) throws ExpressionFunctionExecutionException;

    @Override
    protected final Object doOperation(SimpleAlgorithmConfigurator configurator, Object ... parameters) throws ExpressionFunctionExecutionException {
        if (configurator == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "configurator"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameters"));
        }
        if (parameters.length < 2) {
            throw new ExpressionFunctionExecutionException(LNG.get((String)"csbase.logic.algorithms.parameters.MissingTableName"), this, parameters.length);
        }
        if (!(parameters[0] instanceof String)) {
            throw new ExpressionFunctionExecutionException(LNG.get((String)"csbase.logic.algorithms.parameters.InvalidTableParameter"), this, parameters[0]);
        }
        String parameterName = (String)parameters[0];
        SimpleParameter<?> parameter = configurator.getSimpleParameter(parameterName);
        if (parameter == null) {
            throw new ExpressionFunctionExecutionException(LNG.get((String)"csbase.logic.algorithms.parameters.TableNotFoundInConfigurator"), parameterName, configurator, this);
        }
        if (!(parameter instanceof TableParameter)) {
            throw new ExpressionFunctionExecutionException(LNG.get((String)"csbase.logic.algorithms.parameters.NotATable"), parameterName, configurator, this);
        }
        TableParameter tableParameter = (TableParameter)parameter;
        if (!(parameters[1] instanceof Double)) {
            throw new ExpressionFunctionExecutionException(LNG.get((String)"csbase.logic.algorithms.parameters.NotATableColumn"), this, parameters[1]);
        }
        int columnIndex = ((Double)parameters[1]).intValue();
        if (columnIndex >= tableParameter.getColumnCount()) {
            throw new ExpressionFunctionExecutionException(LNG.get((String)"csbase.logic.algorithms.parameters.ColumnNotFoundInConfigurator"), parameterName, columnIndex, configurator, this);
        }
        List<Object> values = new ArrayList(tableParameter.getRowCount());
        for (int i = 0; i < tableParameter.getRowCount(); ++i) {
            Object value = tableParameter.getItemValue(i, columnIndex);
            values.add(value);
        }
        values = Collections.unmodifiableList(values);
        Object[] newParameters = new Object[parameters.length - 2];
        for (int i = 0; i < newParameters.length; ++i) {
            newParameters[i] = parameters[i + 2];
        }
        return this.doOperation(values, newParameters);
    }

    private static Class<?>[] createParameterTypes(Class<?>[] parameterTypes) {
        if (parameterTypes == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameterTypes"));
        }
        Class[] newParameterTypes = new Class[parameterTypes.length + 2];
        newParameterTypes[0] = String.class;
        newParameterTypes[1] = Double.class;
        for (int i = 2; i < newParameterTypes.length; ++i) {
            newParameterTypes[i] = parameterTypes[i - 2];
        }
        return newParameterTypes;
    }
}

