/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.AdministrationEvent;
import csbase.logic.Getter;
import csbase.logic.IdInterface;
import csbase.logic.RoleInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.util.restart.RestartListener;
import csbase.util.restart.RestartManager;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import tecgraf.javautils.core.lng.LNG;

public class Role
implements Serializable,
IdInterface {
    private final Object id;
    private final RoleInfo info;
    private static Hashtable<Object, Role> roles = new Hashtable();
    private static boolean hasAllRoles = false;
    private static Observable observable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };

    public Role(Object id, RoleInfo info) {
        this.id = id;
        this.info = info;
    }

    public static Role getRole(Object id) throws RemoteException {
        if (id == null) {
            return null;
        }
        Role role = roles.get(id);
        if (role == null && !hasAllRoles && (role = ClientRemoteLocator.administrationService.getRole(id)) != null) {
            roles.put(id, role);
        }
        return role;
    }

    public static Role getRoleByName(String name) throws Exception {
        List<Role> allRoles = Role.getAllRoles();
        for (Role role : allRoles) {
            if (!role.getName().equalsIgnoreCase(name)) continue;
            return role;
        }
        return null;
    }

    public static List<Role> getAllRoles() throws RemoteException {
        if (hasAllRoles) {
            return Role.rolesToVector();
        }
        List<Role> allRoles = ClientRemoteLocator.administrationService.getAllRoles();
        for (Role role : allRoles) {
            if (roles.containsKey(role.getId())) continue;
            roles.put(role.getId(), role);
        }
        hasAllRoles = true;
        return allRoles;
    }

    public static boolean existsAnotherRole(Object id, String name) throws Exception {
        Role anotherRole = Role.getRoleByName(name);
        return anotherRole != null && !anotherRole.getId().equals(id);
    }

    public static List<Role> getAllRoles(boolean sortByName) throws Exception {
        List<Role> allRoles = Role.getAllRoles();
        if (sortByName) {
            Collections.sort(allRoles, Role.getNameComparator());
        }
        return allRoles;
    }

    private static Vector<Role> rolesToVector() {
        Vector<Role> allRoles = new Vector<Role>();
        Enumeration<Role> e = roles.elements();
        while (e.hasMoreElements()) {
            allRoles.add(e.nextElement());
        }
        return allRoles;
    }

    public static Role createRole(RoleInfo info) throws Exception {
        if (info.name == null || info.name.trim().equals("")) {
            throw new Exception("Role.createRole: " + LNG.get((String)"csbase.logic.EmptyRoleName"));
        }
        if (Role.getRoleByName(info.name) != null) {
            return null;
        }
        Role role = ClientRemoteLocator.administrationService.createRole(info);
        if (role != null) {
            roles.put(role.getId(), role);
        }
        return role;
    }

    public static Role modifyRole(Object id, RoleInfo info) throws Exception {
        Role role = Role.getRole(id);
        if (role == null) {
            return null;
        }
        if (!role.getName().equals(info.name) && Role.existsAnotherRole(id, info.name)) {
            return null;
        }
        role = ClientRemoteLocator.administrationService.modifyRole(id, info);
        if (role == null) {
            roles.put(id, role);
        }
        return role;
    }

    public static void deleteRole(Object id) throws Exception {
        ClientRemoteLocator.administrationService.deleteRole(id);
        roles.remove(id);
    }

    public static void update(AdministrationEvent event) {
        Role role = (Role)event.item;
        Object id = role.getId();
        switch (event.type) {
            case 1: 
            case 2: {
                roles.put(id, role);
                break;
            }
            case 3: {
                roles.remove(id);
            }
        }
        observable.notifyObservers(event);
    }

    public static void addObserver(Observer o) {
        observable.addObserver(o);
    }

    public static void deleteObserver(Observer o) {
        observable.deleteObserver(o);
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public String getName() {
        return this.info.name;
    }

    public String getDescription() {
        return this.info.description;
    }

    public Object[] getPermissionIds() {
        return this.info.permissionIds;
    }

    public void setPermissionIds(Object[] permissionIds) {
        this.info.permissionIds = permissionIds;
    }

    public RoleInfo getRoleInfo() {
        return (RoleInfo)this.info.clone();
    }

    public static Comparator<Role> getNameComparator() {
        Comparator<Role> roleComparator = new Comparator<Role>(){

            @Override
            public int compare(Role r1, Role r2) {
                return r1.getName().compareTo(r2.getName());
            }
        };
        return roleComparator;
    }

    public static Comparator<Role> getDescrComparator() {
        Comparator<Role> roleComparator = new Comparator<Role>(){

            @Override
            public int compare(Role r1, Role r2) {
                return r1.getDescription().compareTo(r2.getDescription());
            }
        };
        return roleComparator;
    }

    public static Getter getNameGetter() {
        Getter nameGetter = new Getter(){

            @Override
            public Object get(Object o) {
                Role role = (Role)o;
                return role.getName();
            }
        };
        return nameGetter;
    }

    public static Getter getDescrGetter() {
        Getter descrGetter = new Getter(){

            @Override
            public Object get(Object o) {
                Role role = (Role)o;
                return role.getDescription();
            }
        };
        return descrGetter;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Role)) {
            return false;
        }
        Role role = (Role)obj;
        return role.getId().equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equalContents(Object obj) {
        if (!(obj instanceof Role)) {
            return false;
        }
        Role role = (Role)obj;
        return role.getId().equals(this.id) && role.getRoleInfo().equals(this.info);
    }

    public static boolean hasAnyRoleWithPermission(Object permissionId) throws RemoteException {
        List<Role> rs = Role.getAllRoles();
        for (int i = 0; i < rs.size(); ++i) {
            Object[] perms = rs.get(i).getPermissionIds();
            if (perms == null) continue;
            for (int j = 0; j < perms.length; ++j) {
                if (!permissionId.equals(perms[j])) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.id + " - " + this.info.toString();
    }

    static {
        RestartManager.getInstance().addListener(new RestartListener(){

            public void restart() {
                hasAllRoles = false;
                roles = new Hashtable();
                observable.deleteObservers();
            }
        });
    }
}

