/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationSuccess;
import java.rmi.RemoteException;
import tecgraf.javautils.core.lng.LNG;

public final class IntegerParameterValidator
extends SimpleParameterValidator<Integer> {
    private Integer maximum;
    private Integer minimum;

    public IntegerParameterValidator(boolean isOptional, Integer maximum, Integer minimum) {
        super(isOptional);
        this.setMaximum(maximum);
        this.setMinimum(minimum);
    }

    public Integer getMaximum() {
        return this.maximum;
    }

    public Integer getMinimum() {
        return this.minimum;
    }

    @Override
    public Object convert(Object value) throws Exception {
        long l;
        if (Integer.class.isInstance(value)) {
            return value;
        }
        if (Long.class.isInstance(value) && ((l = ((Long)value).longValue()) > Integer.MAX_VALUE || l < Integer.MIN_VALUE)) {
            throw new Exception("Value out of range.");
        }
        if (Double.class.isInstance(value)) {
            throw new Exception("Double/float values are not permitted for integer.");
        }
        String className = value.getClass().getName();
        throw new Exception("Bad conversion from " + className + ".");
    }

    @Override
    public Validation validateValue(SimpleParameter<?> parameter, Integer value, ValidationContext context) throws RemoteException {
        Validation validationResult = super.validateValue(parameter, value, context);
        if (!validationResult.isWellSucceeded()) {
            return validationResult;
        }
        if (parameter.isEnabled() && parameter.isEnabled() && value != null) {
            if (value.equals(Integer.MIN_VALUE)) {
                return new ValidationError(new LocalizedMessage(IntegerParameterValidator.class, "error_value", new Object[]{parameter.getLabel()}));
            }
            if (this.minimum != null && value.compareTo(this.minimum) < 0) {
                LocalizedMessage message = new LocalizedMessage(IntegerParameterValidator.class, "bellow_minimum", new Object[]{parameter.getLabel(), value, this.minimum});
                return new ValidationError(message);
            }
            if (this.maximum != null && value.compareTo(this.maximum) > 0) {
                LocalizedMessage message = new LocalizedMessage(IntegerParameterValidator.class, "above_maximum", new Object[]{parameter.getLabel(), value, this.maximum});
                return new ValidationError(message);
            }
        }
        return new ValidationSuccess();
    }

    public void setMaximum(Integer maximum) {
        if (this.minimum != null && maximum != null && maximum.compareTo(this.minimum) < 0) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.MaxLessThanMin"));
        }
        this.maximum = maximum;
    }

    public void setMinimum(Integer minimum) {
        if (this.maximum != null && minimum != null && minimum.compareTo(this.maximum) > 0) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.MinGreaterThenMax"));
        }
        this.minimum = minimum;
    }
}

