package csbase.console;

import org.kohsuke.args4j.Option;

/**
 * Parmetros da linha de comando a serem tratados via args4j. Esses parmetros
 * so usados na aplicao de console {@link CheckBundlesApp}.
 * 
 * @author Tecgraf
 */
public class CheckBundlesParams extends BasicParams {

  /**
   * Login do usurio (opcional, default = admin).
   */
  @Option(name = "--user", aliases = "-u", usage = "login do usurio (opcional)", metaVar = "usr")
  String userLogin = null;

  /**
   * Login do usurio (opcional, default = admin).
   */
  @Option(name = "--english", aliases = "-e", usage = "usar o idioma ingls")
  boolean english;

  /**
   * Verifica os bundles de uma aplicao especfica.
   */
  @Option(name = "--app", usage = "verifica as chaves de bundles de uma aplicao especfica", metaVar = "app-id")
  String appToCheck;

  /**
   * Verifica os bundles de uma aplicao especfica.
   */
  @Option(name = "--all-apps", usage = "verifica as chaves de bundles de todas as aplicaes", metaVar = "true/false")
  boolean checkAllApps;

  /**
   * Verifica os bundles de uma aplicao especfica.
   */
  @Option(name = "--unreferenced", usage = "mostra as chaves de bundles que no esto sendo referenciadas no cdigo fonte", metaVar = "true/false")
  boolean showUnreferencedKeys;
}
