/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.console.AbstractConsoleApp;
import csbase.console.BasicParams;
import csbase.logic.User;
import csbase.logic.UserOutline;
import csbase.logic.diagnosticservice.CommandExecutionStatisticsInfo;
import csbase.logic.diagnosticservice.LoginStatisticsInfo;
import csbase.logic.diagnosticservice.UsersStatisticsInfo;
import csbase.remote.ClientRemoteLocator;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class Statistics
extends AbstractConsoleApp {
    public Statistics(String[] args) {
        super(args);
    }

    @Override
    public final String getLogin() {
        return (String)User.getAdminId();
    }

    private void showStats() throws RemoteException {
        this.showBasicInfo();
        this.showUsersInfo();
        this.showLoginStats(10);
        CommandExecutionStatisticsInfo executionStats = ClientRemoteLocator.diagnosticService.getCommandExecutionStatisticsInfo();
        this.showExeTypeStats(executionStats);
        this.showStats("Execu\u00e7\u00f5es simples, por algoritmo:", executionStats.simpleAlgoExecutionStats);
        this.showStats("Execu\u00e7\u00f5es de fluxos, por algoritmo:", executionStats.flowAlgoExecutionStats);
        this.showUserExecutionStats(executionStats, 10);
        this.showStats("Execu\u00e7\u00f5es por m\u00e1quina:", executionStats.sgasExecutionStats);
        this.showStats("Resultados das execu\u00e7\u00f5es simples:", executionStats.simpleAlgoResultsStats);
        this.showStats("Resultados das execu\u00e7\u00f5es dos fluxos:", executionStats.flowAlgoResultsStats);
        this.println();
    }

    private void showUsersInfo() throws RemoteException {
        UsersStatisticsInfo usersBasicInfo = ClientRemoteLocator.diagnosticService.getUsersStatisticsInfo();
        int numUsers = usersBasicInfo.numRegisteredUsers;
        this.println("\nUsu\u00e1rios cadastrados: %d", numUsers - 1);
        UserOutline[] loggedUsers = usersBasicInfo.connectedUsers;
        this.println("\nUsu\u00e1rios conectados: %d", loggedUsers.length - 1);
    }

    private void showUserExecutionStats(CommandExecutionStatisticsInfo executionStats, int limit) {
        this.showSortedMap("Execu\u00e7\u00f5es por usu\u00e1rio", limit, executionStats.userExecutionStats);
    }

    private boolean showExeTypeStats(CommandExecutionStatisticsInfo executionStats) {
        Map exeStats = executionStats.exeStats;
        String obs = null;
        int flowStats = executionStats.flowStats;
        if (flowStats > 0) {
            obs = "(" + flowStats + " fluxos)";
        }
        return this.showStats("Execu\u00e7\u00f5es por tipo:", exeStats, obs);
    }

    private void showLoginStats(int limit) throws RemoteException {
        LoginStatisticsInfo loginInfo = ClientRemoteLocator.diagnosticService.getLoginStatisticsInfo();
        this.showSortedMap("Usu\u00e1rios autenticados com sucesso", limit, loginInfo.succeededLogins);
        if (!loginInfo.failedLogins.isEmpty()) {
            this.showSortedMap("Erros de autentica\u00e7\u00e3o", limit, loginInfo.failedLogins);
        }
    }

    private <T> boolean showSortedMap(String header, int limit, Map<T, Integer> statsMap) {
        if (statsMap.isEmpty()) {
            return false;
        }
        this.println("\n%s (top %d):", header, limit);
        return this.showSortedMap(limit, statsMap);
    }

    private <T> boolean showSortedMap(int limit, Map<T, Integer> statsMap) {
        if (statsMap.isEmpty()) {
            return false;
        }
        List<T> sortedKeys = Statistics.sortMapByValues(statsMap, true);
        int maxItems = limit > 0 ? limit : sortedKeys.size();
        int maxLen = Statistics.getMaxStrLen(sortedKeys);
        String format = "%s%-" + maxLen + "s : %d";
        for (T key : sortedKeys) {
            this.println(format, "    ", key, statsMap.get(key));
            if (--maxItems == 0) break;
        }
        return true;
    }

    private <T> boolean showStats(String header, Map<T, Integer> map) {
        return this.showStats(header, map, null);
    }

    private <T> boolean showStats(String header, Map<T, Integer> map, String totalObs) {
        if (map.isEmpty()) {
            return false;
        }
        this.println(String.valueOf('\n') + header, new Object[0]);
        int total = 0;
        int maxLen = Statistics.getMaxStrLen(map.keySet());
        String formatStr = "%s%-" + maxLen + "s : %d";
        for (Map.Entry<T, Integer> entry : map.entrySet()) {
            Integer v = entry.getValue();
            this.println(formatStr, "    ", entry.getKey(), v);
            total += v.intValue();
        }
        if (totalObs == null) {
            this.println(formatStr, "    ", "TOTAL", total);
        } else {
            this.println(String.valueOf(formatStr) + " %s", "    ", "TOTAL", total, totalObs);
        }
        return true;
    }

    private static <T> List<T> sortMapByValues(final Map<T, Integer> map, final boolean descending) {
        Comparator comparator = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                if (descending) {
                    return ((Integer)map.get(o2)).compareTo((Integer)map.get(o1));
                }
                return ((Integer)map.get(o1)).compareTo((Integer)map.get(o2));
            }
        };
        ArrayList<T> result = new ArrayList<T>(map.keySet());
        Collections.sort(result, comparator);
        return result;
    }

    @Override
    protected BasicParams createParams() {
        return new BasicParams();
    }

    public static void main(String[] args) {
        Statistics stats = null;
        try {
            try {
                stats = new Statistics(args);
                if (stats.login()) {
                    stats.showStats();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (stats != null) {
                    stats.logout();
                }
            }
        }
        finally {
            if (stats != null) {
                stats.logout();
            }
        }
    }
}

