/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.client.externalresources.StandaloneLocalFile;
import csbase.console.AbstractConsoleApp;
import csbase.console.AlgorithmsPackParams;
import csbase.console.BasicParams;
import csbase.exception.ServiceFailureException;
import csbase.logic.SyncRemoteFileChannel;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.logic.algorithms.AlgorithmsPack;
import csbase.logic.algorithms.ImportAlgorithmsPackTransferInfo;
import csbase.logic.algorithms.PAImportOperation;
import csbase.remote.ClientRemoteLocator;
import java.io.File;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import tecgraf.ftc.common.logic.RemoteFileChannelInfo;

public class ImportAlgoPack
extends AbstractConsoleApp {
    private List<AlgorithmInfo> algorithmsList;

    ImportAlgoPack(String[] args) {
        super(args);
    }

    @Override
    protected BasicParams createParams() {
        return new AlgorithmsPackParams();
    }

    @Override
    protected void postLoginInit() throws RemoteException {
    }

    private boolean transfer(StandaloneLocalFile file, RemoteFileChannelInfo info) throws Exception {
        SyncRemoteFileChannel channel = new SyncRemoteFileChannel(info.getIdentifier(), info.isWritable(), info.getHost(), info.getPort(), info.getKey());
        channel.open(!info.isWritable());
        InputStream inputStream = file.getInputStream();
        long totalBytes = channel.syncTransferFrom(inputStream, 0L, file.getLength());
        inputStream.close();
        channel.close();
        return totalBytes == file.getLength();
    }

    @Override
    protected boolean preLogout() {
        return true;
    }

    @Override
    public String getLogin() {
        AlgorithmsPackParams params = (AlgorithmsPackParams)this.getParams();
        String login = (String)(params.userLogin == null ? User.getAdminId() : params.userLogin);
        return login;
    }

    private File getLocalSrcFile(String localSrcPath) {
        File localFile = localSrcPath.charAt(0) != '/' ? new File(this.getCurrentDir(), localSrcPath) : new File(localSrcPath);
        if (!localFile.exists()) {
            this.printError(localSrcPath + " n\u00e3o existe", new Object[0]);
            return null;
        }
        if (localFile.isDirectory()) {
            this.printError(localSrcPath + " \u00e9 um diret\u00f3rio", new Object[0]);
            return null;
        }
        return localFile;
    }

    private void execute() throws Exception {
        AlgorithmsPackParams params = (AlgorithmsPackParams)this.getParams();
        if (params.startPA != null) {
            String localPAPath = params.startPA;
            this.startPAImport(localPAPath);
            return;
        }
        if (params.finishPA) {
            if (params.token == null) {
                this.printError("token do dado do Pacote de Algoritmos n\u00e3o foi especificado", new Object[0]);
            } else {
                this.finishPAImport(params.token);
            }
            return;
        }
        if (params.validatePA) {
            if (params.token == null) {
                this.printError("token do dado do Pacote de Algoritmos n\u00e3o foi especificado", new Object[0]);
            } else {
                this.validatePA(params.token);
            }
            return;
        }
        if (params.listAlgorithms) {
            if (params.token == null) {
                this.printError("token do dado do Pacote de Algoritmos n\u00e3o foi especificado", new Object[0]);
            } else {
                this.listAlgorithms(params.token);
            }
            return;
        }
        if (params.algoToList != null) {
            if (params.token == null) {
                this.printError("token do dado do Pacote de Algoritmos n\u00e3o foi especificado", new Object[0]);
            } else {
                this.listAlgoInfo(params.token, params.algoToList);
            }
            return;
        }
        if (!this.validateAlgorithmsOperations(params)) {
            return;
        }
        if (params.replaceAlgorithms) {
            if (params.token == null) {
                this.printError("token do dado do Pacote de Algoritmos n\u00e3o foi especificado", new Object[0]);
                return;
            }
            this.replaceAlgorithms(params.token);
        } else if (params.keepAlgorithms) {
            if (params.token == null) {
                this.printError("token do dado do Pacote de Algoritmos n\u00e3o foi especificado", new Object[0]);
                return;
            }
            this.keepAlgorithms(params.token);
        } else if (params.mergeAlgorithms) {
            if (params.token == null) {
                this.printError("token do dado do Pacote de Algoritmos n\u00e3o foi especificado", new Object[0]);
                return;
            }
            this.mergeAlgorithms(params);
        }
    }

    private boolean validateAlgorithmsOperations(AlgorithmsPackParams params) {
        boolean hasMergeOperations;
        boolean validate = true;
        int algorithmsOpsNumber = 0;
        algorithmsOpsNumber += params.replaceAlgorithms ? 1 : 0;
        algorithmsOpsNumber += params.mergeAlgorithms ? 1 : 0;
        if ((algorithmsOpsNumber += params.keepAlgorithms ? 1 : 0) == 0) {
            validate = false;
            this.printError("a importa\u00e7\u00e3o de PA requer a escolha de pelo menos uma opera\u00e7\u00e3o a ser realizada sobre os algoritmos do PA", new Object[0]);
        } else if (algorithmsOpsNumber > 1) {
            validate = false;
            this.printError("escolha somente uma opera\u00e7\u00e3o para ser realizada sobre os algoritmos do PA", new Object[0]);
        } else if (params.replaceAlgorithms || params.keepAlgorithms) {
            return true;
        }
        int categoriesOpsNumber = 0;
        categoriesOpsNumber += params.replaceCategories ? 1 : 0;
        categoriesOpsNumber += params.mergeCategories ? 1 : 0;
        if ((categoriesOpsNumber += params.keepCategories ? 1 : 0) == 0) {
            validate = false;
            this.printError("o merge de algoritmos requer a escolha de uma opera\u00e7\u00e3o sobre as categorias dos algoritmos do Pacote de Algoritmos", new Object[0]);
        } else if (categoriesOpsNumber > 1) {
            validate = false;
            this.printError("escolha somente uma opera\u00e7\u00e3o para ser realizada sobre as categorias dos algoritmos do PA", new Object[0]);
        }
        int versionOpsNumber = 0;
        versionOpsNumber += params.replaceVersions ? 1 : 0;
        if ((versionOpsNumber += params.keepVersions ? 1 : 0) == 0) {
            validate = false;
            this.printError("o merge de algoritmos requer a escolha de uma opera\u00e7\u00e3o sobre as vers\u00f5es dos algoritmos do Pacote de Algoritmos", new Object[0]);
        } else if (versionOpsNumber > 1) {
            validate = false;
            this.printError("escolha somente uma opera\u00e7\u00e3o para ser realizada sobre as vers\u00f5es dos algoritmos do PA", new Object[0]);
        }
        boolean bl = hasMergeOperations = categoriesOpsNumber > 0 || versionOpsNumber > 0;
        if (validate && !params.mergeAlgorithms && hasMergeOperations) {
            validate = false;
            this.printError("somente a opera\u00e7\u00e3o de merge de algoritmos requer a escolha de uma opera\u00e7\u00e3o sobre vers\u00f5es e categorias dos algoritmos do PA", new Object[0]);
        }
        return validate;
    }

    private void validatePA(String token) throws Exception {
        String result = "";
        try {
            result = ClientRemoteLocator.algorithmService.validateAlgorithmsPack(token);
        }
        catch (ServiceFailureException e) {
            System.err.println(e.getMessage());
        }
        System.out.println("\nResultado da valida\u00e7\u00e3o do PA com token <" + token + ">:\n" + result);
    }

    private void finishPAImport(String token) throws Exception {
        try {
            ClientRemoteLocator.algorithmService.finishImportAlgorithmsPack(token);
        }
        catch (ServiceFailureException e) {
            System.err.println(e.getMessage());
        }
        System.out.println("Processo de importa\u00e7\u00e3o do PA com token <" + token + "> est\u00e1 finalizado.");
    }

    private void startPAImport(String localPAPath) throws Exception {
        ImportAlgorithmsPackTransferInfo importAlgoPackInfo = ClientRemoteLocator.algorithmService.prepareImportAlgorithmsPack();
        RemoteFileChannelInfo requestInfo = importAlgoPackInfo.getChannel();
        File localPAFile = this.getLocalSrcFile(localPAPath);
        if (localPAFile == null) {
            System.err.println("Path inexistente para Pacote de algoritmo.");
            return;
        }
        StandaloneLocalFile standAloneFile = new StandaloneLocalFile(localPAFile);
        if (!this.transfer(standAloneFile, requestInfo)) {
            this.logout();
        }
        String token = importAlgoPackInfo.getImportDataToken();
        System.out.println("Token correspondente ao PA: ");
        System.out.println(token);
    }

    private AlgorithmInfo getAlgoInfo(String token, String algoName) throws Exception {
        List<AlgorithmInfo> algorithms = this.getAlgorithmsFromPack(token);
        if (algorithms != null) {
            for (AlgorithmInfo algorithmInfo : algorithms) {
                if (!algorithmInfo.getName().equals(algoName)) continue;
                return algorithmInfo;
            }
        }
        return null;
    }

    private void listAlgorithms(String token) throws Exception {
        List<AlgorithmInfo> algorithms = this.getAlgorithmsFromPack(token);
        if (algorithms != null) {
            for (AlgorithmInfo algorithmInfo : algorithms) {
                this.printAlgoData(algorithmInfo);
            }
        }
    }

    private void listAlgoInfo(String token, String algoName) throws Exception {
        AlgorithmInfo algoInfo = this.getAlgoInfo(token, algoName);
        if (algoInfo != null) {
            this.printAlgoInfo(algoInfo);
        } else {
            System.err.println("Algoritmo \"" + algoName + "\" n\u00e3o encontrado.");
        }
    }

    private void printAlgoData(AlgorithmInfo algo) {
        System.out.println("\nDados do algoritmo criado a partir do xml: ");
        System.out.println("Id: " + algo.getId());
        System.out.println("Nome: " + algo.getName());
        System.out.println("Descri\u00e7\u00e3o: " + algo.getDescription());
    }

    private void printAlgoInfo(AlgorithmInfo algo) {
        this.printAlgoData(algo);
        Hashtable propertyValues = algo.getPropertyValues();
        Set entrySet = propertyValues.entrySet();
        System.out.println("\n>> Propriedades do algoritmo: " + entrySet.size());
        for (Map.Entry entry : entrySet) {
            System.out.println((String)entry.getKey() + " = " + (String)entry.getValue());
        }
        Vector versions = algo.getVersions();
        System.out.println("\n>> Vers\u00f5es do algoritmo: " + versions.size());
        for (AlgorithmVersionInfo algoVersionInfo : versions) {
            System.out.println("\n-> Vers\u00e3o: " + algoVersionInfo);
            System.out.println("descri\u00e7\u00e3o: " + algoVersionInfo.getDescription());
            Map properties = algoVersionInfo.getPropertyValues();
            entrySet.clear();
            entrySet = properties.entrySet();
            System.out.println("\nPropriedades da vers\u00e3o do algoritmo: " + entrySet.size());
            for (Map.Entry entry : entrySet) {
                System.out.println((String)entry.getKey() + " = " + (String)entry.getValue());
            }
        }
        List list = algo.getAlgoPackCategoryFullNames();
        System.out.println("\n>> Categorias do algoritmo: " + list.size());
        for (String categoryFullName : list) {
            System.out.println("\n-> Nome completo: " + categoryFullName);
        }
    }

    public static void main(String[] args) throws Exception {
        ImportAlgoPack importPaClient = new ImportAlgoPack(args);
        if (importPaClient.login()) {
            System.out.println("Processo de importa\u00e7\u00e3o de um Pacote de Algoritmos...");
            importPaClient.execute();
            importPaClient.logout();
        }
    }

    private List<AlgorithmInfo> getAlgorithmsFromPack(String token) throws Exception {
        AlgorithmsPack algorithmPack = null;
        if (this.algorithmsList == null) {
            try {
                algorithmPack = ClientRemoteLocator.algorithmService.getAlgorithmsPackInfo(token);
            }
            catch (ServiceFailureException e) {
                System.err.println(e.getMessage());
                return null;
            }
            catch (RemoteException e) {
                System.err.println(e.getMessage());
                return null;
            }
            this.algorithmsList = algorithmPack.getAlgorithms();
        }
        return this.algorithmsList;
    }

    private void replaceAlgorithms(String token) throws Exception {
        try {
            PAImportOperation[] operations = new PAImportOperation[]{PAImportOperation.REPLACE_ALGORITHMS};
            if (!ClientRemoteLocator.algorithmService.importAlgorithmsPack(token, operations)) {
                System.err.println(String.format("Ocorreu uma falha na importa\u00e7\u00e3o dos algoritmos do PA com token %s.\nExecute o comando para validar o Pacote de Algoritmos.", token));
                return;
            }
            System.out.println("\nA importa\u00e7\u00e3o de algoritmos ocorreu com sucesso.\nTodos os algoritmos com mesmo identificador no PA, foram substitu\u00eddos no reposit\u00f3rio de algoritmos.");
        }
        catch (ServiceFailureException e) {
            System.err.println(e.getMessage());
        }
    }

    private void keepAlgorithms(String token) throws Exception {
        try {
            PAImportOperation[] operations = new PAImportOperation[]{PAImportOperation.KEEP_ALGORITHMS};
            if (!ClientRemoteLocator.algorithmService.importAlgorithmsPack(token, operations)) {
                System.err.println(String.format("Ocorreu uma falha na importa\u00e7\u00e3o dos algoritmos do PA com token %s.\nExecute o comando para validar o Pacote de Algoritmos.", token));
                return;
            }
            System.out.println("\nA importa\u00e7\u00e3o de algoritmos ocorreu com sucesso.\nTodos os algoritmos com mesmo identificador no PA, foram mantidos no reposit\u00f3rio de algoritmos.");
        }
        catch (ServiceFailureException e) {
            System.err.println(e.getMessage());
        }
    }

    private void mergeAlgorithms(AlgorithmsPackParams params) throws RemoteException {
        String token = params.token;
        try {
            PAImportOperation[] operations = new PAImportOperation[]{PAImportOperation.MERGE_ALGORITHMS, this.getVersionsOperation(params), this.getCategoriesOperation(params)};
            if (!ClientRemoteLocator.algorithmService.importAlgorithmsPack(token, operations)) {
                System.err.println(String.format("Ocorreu uma falha na importa\u00e7\u00e3o dos algoritmos do PA com token %s.\nExecute o comando para validar o Pacote de Algoritmos.", token));
                return;
            }
            System.out.println("\nA importa\u00e7\u00e3o de algoritmos ocorreu com sucesso.\nTodos os algoritmos com mesmo identificador no PA, foram combinados no reposit\u00f3rio de algoritmos, conforme opera\u00e7\u00f5es definidas no comando.");
        }
        catch (ServiceFailureException e) {
            System.err.println(e.getMessage());
        }
    }

    private PAImportOperation getCategoriesOperation(AlgorithmsPackParams params) {
        if (params.replaceCategories) {
            return PAImportOperation.REPLACE_CATEGORIES;
        }
        if (params.mergeCategories) {
            return PAImportOperation.MERGE_CATEGORIES;
        }
        return PAImportOperation.KEEP_CATEGORIES;
    }

    private PAImportOperation getVersionsOperation(AlgorithmsPackParams params) {
        if (params.replaceVersions) {
            return PAImportOperation.REPLACE_VERSIONS;
        }
        return PAImportOperation.KEEP_VERSIONS;
    }
}

