package csbase.console;

import org.kohsuke.args4j.Option;

/**
 * Parmetros especficos do cliente console para criao de um algoritmo.
 *
 * @author Tecgraf
 */
class CreateAlgorithmParams extends BasicParams {

  /**
   * Login do usurio (opcional, default = admin).
   */
  @Option(name = "--user", aliases = "-u", usage = "login do usurio (opcional)", metaVar = "<login do usurio>")
  String userLogin = null;

  /**
   * Id do algoritmo.
   */
  @Option(name = "--algorithm-id", required = true, aliases = "-i", usage = "id do algoritmo", metaVar = "<id do algoritmo>")
  String algorithmId = null;

  /**
   * Nome do algoritmo.
   */
  @Option(name = "--algorithm-name", required = true, aliases = "-n", usage = "nome do algoritmo", metaVar = "<nome do algoritmo>")
  String algorithmName = null;

  /**
   * Atributos extras do algoritmo.
   *
   * Formato: "<id_atributo_1> = <valor_atributo_1>,<id_atributo_2> =
   * <valor_atributo_2>,...,<id_atributo_n> = <valor_atributo_n>"
   */
  @Option(name = "--attributes", aliases = "-a", usage = "atributos do algoritmo (\"<id_atributo_1> = <valor_atributo_1>,<id_atributo_2> = <valor_atributo_2>,...,<id_atributo_n> = <valor_atributo_n>\")", metaVar = "<atributos do algoritmo>")
  String attributes = null;

}
