package csbase.console;

import java.util.Vector;

import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionInfo;
import csbase.remote.ClientRemoteLocator;

/**
 * Cliente sem interface grfica, para realizar a listagem de Verses de
 * Algoritmo. Esse cliente deve ser executado diretamente da linha de comando.
 *
 * @author Tecgraf
 */
class ListAlgoVersions extends AbstractConsoleApp {

  /**
   * Construtor do cliente para listar verses de um algoritmo. Obtm a senha
   * interativamente.
   *
   * @param args parmetros fornecidos na linha de comando
   */
  ListAlgoVersions(String[] args) {
    super(args);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected BasicParams createParams() {
    return new ListAlgoVersionsParams();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void postLoginInit() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean preLogout() {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getLogin() {
    ListAlgoVersionsParams params = (ListAlgoVersionsParams) getParams();
    String login = (String) (params.userLogin == null ? User.getAdminId()
      : params.userLogin);
    return login;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ExitCode execute() throws Exception {
    ListAlgoVersionsParams params = (ListAlgoVersionsParams) getParams();
    return startAlgorithmVersionList(params.algorithmId);
  }

  /**
   * Lista as verses do algoritmo.
   *
   * @param algorithmId Id do algoritmo.
   * @return Cdigo de sada.
   * @throws Exception Erro na obteno de verses do algoritmo.
   */
  private static ExitCode startAlgorithmVersionList(String algorithmId)
    throws Exception {
    /*
     * TODO: Cast pra Object necessrio pois alm do getInfo(Object) desejado,
     * existe um mtodo getInfo(String) que espera no o id mas o nome do
     * algoritmo. Talvez fosse o caso destes mtodos terem nomes diferentes.
     */
    AlgorithmInfo info =
      ClientRemoteLocator.algorithmService.getInfo((Object) algorithmId);
    if (info == null) {
      System.err.println("Id de algoritmo invlido.");
      // Exit code de id de algoritmo invlido.
      return ExitCode.FAILURE;
    }

    Vector<AlgorithmVersionInfo> versions = info.getVersions();
    if (versions == null || versions.size() == 0) {
      System.out.println("Nenhuma verso do algoritmo foi encontrada.");
      // Exit code de sucesso.
      return ExitCode.SUCCESS;
    }
    System.out.println("Verses encontradas:");
    for (AlgorithmVersionInfo versionInfo : versions) {
      System.out.println("Verso: " + versionInfo.getId());
    }
    // Exit code de sucesso.
    return ExitCode.SUCCESS;
  }

}
