package csbase.console;

import java.util.Arrays;
import java.util.List;

import csbase.exception.PermissionException;
import csbase.logic.User;
import csbase.logic.algorithms.AlgorithmInfo;
import csbase.logic.algorithms.AlgorithmVersionId;
import csbase.remote.ClientRemoteLocator;

/**
 * Cliente sem interface grfica, para realizar a remoo de Verso de
 * Algoritmo. Esse cliente deve ser executado diretamente da linha de comando.
 *
 * @author Tecgraf
 */
class RemoveAlgoVersion extends AbstractConsoleApp {

  /**
   * Construtor do cliente para importar uma verso de algoritmo. Obtm a senha
   * interativamente.
   *
   * @param args parmetros fornecidos na linha de comando
   */
  RemoveAlgoVersion(String[] args) {
    super(args);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected BasicParams createParams() {
    return new RemoveAlgoVersionParams();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void postLoginInit() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean preLogout() {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getLogin() {
    RemoveAlgoVersionParams params = (RemoveAlgoVersionParams) getParams();
    String login = (String) (params.userLogin == null ? User.getAdminId()
      : params.userLogin);
    return login;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ExitCode execute() throws Exception {
    RemoveAlgoVersionParams params = (RemoveAlgoVersionParams) getParams();
    return startAlgorithmRemoval(params.algorithmId, params.versionId);
  }

  /**
   * Inicia o processo de remoo de verso de algoritmo.
   *
   * @param algorithmId Id do algoritmo.
   * @param versionId Id da verso.
   * @return Cdigo de sada.
   * @throws Exception Erro na obteno de verses do algoritmo.
   */
  private static ExitCode startAlgorithmRemoval(String algorithmId,
    String versionId) throws Exception {
    /*
     * TODO: Cast pra Object necessrio pois alm do getInfo(Object) desejado,
     * existe um mtodo getInfo(String) que espera no o id mas o nome do
     * algoritmo. Talvez fosse o caso destes mtodos terem nomes diferentes.
     */
    AlgorithmInfo info = ClientRemoteLocator.algorithmService.getInfo(
      (Object) algorithmId);
    if (info == null) {
      System.err.println("Id de algoritmo invlido.");
      // Exit code de id de algoritmo invlido.
      return ExitCode.FAILURE;
    }

    List<Object> list = Arrays.asList(info.getVersionIds());
    for (Object obj : list) {
      if (obj.toString().equalsIgnoreCase(versionId)) {
        try {
          ClientRemoteLocator.algorithmService.removeVersion(algorithmId,
            AlgorithmVersionId.create(versionId));
          System.out.println("Verso " + versionId + " removida.");
          // Exit code de sucesso.
          return ExitCode.SUCCESS;
        }
        catch (PermissionException e) {
          System.out.println(
            "Usurio no tem permisso para remover verso de algoritmo "
              + algorithmId);
          // Exit code de falha de permisso na remoo de verso de algoritmo.
          return ExitCode.FAILURE;
        }
      }
    }
    System.err.println("Verso no encontrada.");
    // Exit code de verso no encontrada.
    return ExitCode.FAILURE;
  }

}
