/*
 * Decompiled with CFR 0.152.
 */
package csbase.console;

import csbase.console.AbstractConsoleApp;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

class InfoTable {
    private boolean isOK = true;
    private String header;
    private Map<String, Object> map;

    InfoTable(String header, boolean sorted) {
        this.header = header;
        this.map = sorted ? new TreeMap<String, Object>() : new LinkedHashMap<String, Object>();
    }

    void add(String label, Object value) {
        this.map.put(label, value);
    }

    void add(String label, Object value, boolean isOK) {
        this.add(label, value);
        this.setOK(isOK);
    }

    void setOK(boolean isOK) {
        this.isOK &= isOK;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("%-50s%s\n", this.header + ':', this.isOK ? "" : "** ERRO **"));
        int maxLen = AbstractConsoleApp.getMaxStrLen(this.map.keySet());
        String format = "    %-" + maxLen + "s : %s\n";
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            builder.append(String.format(format, entry.getKey(), entry.getValue()));
        }
        return builder.toString();
    }

    public boolean isOK() {
        return this.isOK;
    }
}

