package csbase.console;

import csbase.logic.User;
import csbase.logic.algorithms.Category;
import csbase.logic.algorithms.CategorySet;
import csbase.remote.ClientRemoteLocator;

/**
 * Cliente sem interface grfica, para realizar a listagem de Categorias de
 * Algoritmo. Esse cliente deve ser executado diretamente da linha de comando.
 *
 * @author Tecgraf
 */
class ListAlgoCategories extends AbstractConsoleApp {

  /**
   * Construtor do cliente para listar categorias de um algoritmo. Obtm a senha
   * interativamente.
   *
   * @param args parmetros fornecidos na linha de comando
   */
  ListAlgoCategories(String[] args) {
    super(args);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected BasicParams createParams() {
    return new ListAlgoCategoriesParams();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void postLoginInit() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected boolean preLogout() {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getLogin() {
    ListAlgoCategoriesParams params = (ListAlgoCategoriesParams) getParams();
    String login = (String) (params.userLogin == null ? User.getAdminId()
      : params.userLogin);
    return login;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public ExitCode execute() throws Exception {
    return startAlgorithmCategoriesList();
  }

  /**
   * Lista as categorias de algoritmos.
   *
   * @return Cdigo de sada.
   * @throws Exception Erro na obteno de verses do algoritmo.
   */
  private static ExitCode startAlgorithmCategoriesList() throws Exception {
    /*
     * TODO: Cast pra Object necessrio pois alm do getInfo(Object) desejado,
     * existe um mtodo getInfo(String) que espera no o id mas o nome do
     * algoritmo. Talvez fosse o caso destes mtodos terem nomes diferentes.
     */
    CategorySet categorySet =
      ClientRemoteLocator.algorithmService.getAllCategories();
    if (categorySet == null || categorySet.isEmpty()) {
      System.err.println("Nenhuma categoria de algoritmo encontrada.");
      // Exit code de operao bem sucedida.
      return ExitCode.SUCCESS;
    }

    System.out.println("Categorias de algoritmo encontradas:");
    for (Category category : categorySet.getAllCategories()) {
      System.out.println("Categoria: " + category.getFullName());
    }
    // Exit code de sucesso.
    return ExitCode.SUCCESS;
  }

}
