/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.ca.servicos;

import ControleAcesso.Main;
import ControleAcesso.ModControleAcesso;
import ControleAcesso.ModControleDados;
import ControleAcesso.ModPermissao;
import ControleAcesso.ModPrincipal;
import br.com.petrobras.ca.entidades.InformacaoVO;
import br.com.petrobras.ca.entidades.ObjetoVO;
import br.com.petrobras.ca.entidades.PerfilObjetoVO;
import br.com.petrobras.ca.entidades.PerfilVO;
import br.com.petrobras.ca.entidades.UsuarioInformacaoVO;
import br.com.petrobras.ca.entidades.UsuarioVO;
import br.com.petrobras.ca.servicos.ControleAcessoExterno;
import br.com.petrobras.util.excecoes.UsuarioNaoAutenticadoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controle
implements ControleAcessoExterno {
    private static final String RESULTADO_OK = "S";
    private static final String SIM = "S";
    private static final String NAO = "N";
    private Main moduloMain;
    private static Controle instancia = null;

    public static Controle getInstance() {
        if (instancia == null) {
            instancia = new Controle();
        }
        return instancia;
    }

    @Override
    public void conectar(String codigoAplicacaoCA, String codigoAmbienteCA, String senhaAplicacaoCA) throws Exception {
        try {
            this.moduloMain = Main.createObjectAmbiente((String)codigoAplicacaoCA, (String)codigoAmbienteCA);
            this.moduloMain.autenticarSistema(senhaAplicacaoCA);
        }
        catch (Exception ex) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel acessar o sistema no Controle de Acesso: " + ex.getLocalizedMessage());
        }
    }

    @Override
    public boolean autenticar(String login, String senha) throws Exception {
        boolean resultado = false;
        if (this.moduloMain != null) {
            String resultadoString = this.moduloMain.autenticarAD(login, senha);
            if (resultadoString.equals("S")) {
                resultado = true;
            } else {
                throw new UsuarioNaoAutenticadoException("N\u00e3o foi poss\u00edvel autenticar o usu\u00e1rio utilizando a autentica\u00e7\u00e3o integrada.");
            }
        }
        return resultado;
    }

    @Override
    public boolean criarUsuarioExterno(UsuarioVO usuario) throws Exception {
        ModPrincipal principal = this.moduloMain.getPrincipal();
        String resultado = principal.IncluirUsuarioExterno(usuario.getLogin(), null, usuario.getLogin(), usuario.getSenha(), null, null, null, null, null, null, null, null, null, null, null, null, null);
        if (resultado.equals("S")) {
            return true;
        }
        throw new Exception("N\u00e3o foi poss\u00edvel incluir o usu\u00e1rio: " + usuario.getLogin());
    }

    @Override
    public void excluirUsuario(UsuarioVO usuario) throws Exception {
        ModControleDados dados = this.moduloMain.getDados();
        Vector infos = dados.InformacoesUsuario(usuario.getLogin());
        for (Vector info : infos) {
            String nomeInfo = (String)info.get(0);
            dados.ExcluirUsuaValInfoAll(usuario.getLogin(), nomeInfo, "");
        }
        ModPrincipal principal = this.moduloMain.getPrincipal();
        principal.ExcluirUsuaPerfilAll(usuario.getLogin());
    }

    @Override
    public String getValoresInformacao(String nomeInformacao, String loginUsuario) throws Exception {
        String valores = "";
        ModControleDados dados = this.moduloMain.getDados();
        valores = dados.ValoresInformacaoUsuario(nomeInformacao, loginUsuario);
        return valores;
    }

    @Override
    public boolean verificarPermissaoObjeto(String objeto) throws Exception {
        String resultado = "";
        ModPermissao permissao = this.moduloMain.getPermissao();
        resultado = permissao.VerificaPermObj(objeto);
        return resultado.equals("S");
    }

    @Override
    public boolean verificarPermissaoAcao(String objeto, String acao) throws Exception {
        String resultado = "";
        ModPermissao permissao = this.moduloMain.getPermissao();
        resultado = permissao.VerificaPermAcao(objeto, acao);
        return resultado.equals("S");
    }

    @Override
    public boolean usuarioExternoExiste(String login) throws Exception {
        String resultado = "";
        ModPrincipal principal = this.moduloMain.getPrincipal();
        resultado = principal.UsuarioExterno(login);
        return resultado.equals("S");
    }

    @Override
    public boolean atualizarPerfisUsuario(UsuarioVO usuario) throws Exception {
        String resultado = "";
        ModPrincipal principal = this.moduloMain.getPrincipal();
        principal.ExcluirUsuaPerfilAll(usuario.getLogin());
        for (PerfilVO perfil : usuario.getPerfil()) {
            resultado = principal.IncluirPerfilUsuario(usuario.getLogin(), perfil.getCodigo(), "");
        }
        return !resultado.equals("");
    }

    @Override
    public boolean associarInformacaoUsuario(InformacaoVO informacao, String loginUsuario) throws Exception {
        String resultado = "";
        ModControleDados dados = this.moduloMain.getDados();
        resultado = dados.IncluirUsuarioValorInfo(loginUsuario, informacao.getNome(), informacao.getValor(), "", "S", "S", "S", "S", "");
        return resultado.equals("S");
    }

    @Override
    public boolean alterarInformacao(InformacaoVO informacao) throws Exception {
        String resultado = "";
        ModControleDados dados = this.moduloMain.getDados();
        resultado = dados.AlterarValorInformacao(informacao.getNome(), informacao.getValor(), informacao.getDescricao(), "");
        return resultado.equals("S");
    }

    @Override
    public List<String> getUsuariosValorInformacao(InformacaoVO informacao) throws Exception {
        String resultado = "";
        ArrayList<String> usuarios = new ArrayList<String>();
        ModControleDados dados = this.moduloMain.getDados();
        Vector usuariosAssociados = dados.UsuarioValorInformacao(informacao.getNome(), informacao.getValor());
        for (Vector usuario : usuariosAssociados) {
            String chaveUsuario = (String)usuario.get(0);
            usuarios.add(chaveUsuario);
        }
        return usuarios;
    }

    public boolean excluirUsuariosValorInformacao(InformacaoVO informacao) throws Exception {
        String resultado = "";
        List<String> usuarios = this.getUsuariosValorInformacao(informacao);
        ModControleDados dados = this.moduloMain.getDados();
        for (String usuario : usuarios) {
            resultado = dados.ExcluirUsuarioValor(usuario, informacao.getNome(), informacao.getValor());
            if (!resultado.equals(NAO)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean excluirInformacao(InformacaoVO informacao) throws Exception {
        String resultado = "";
        if (this.excluirUsuariosValorInformacao(informacao)) {
            ModControleDados dados = this.moduloMain.getDados();
            resultado = dados.ExcluirValorInformacao(informacao.getNome(), informacao.getValor());
        }
        return resultado.equals("S");
    }

    @Override
    public boolean incluirInformacao(InformacaoVO informacao) throws Exception {
        String resultado = "";
        ModControleDados dados = this.moduloMain.getDados();
        resultado = dados.IncluirValorInformacao(informacao.getNome(), informacao.getValor(), "", "");
        return resultado.equals("S");
    }

    @Override
    public boolean associarInformacaoPerfil(InformacaoVO informacao, String perfil) throws Exception {
        String resultado = "";
        try {
            ModControleDados dados = this.moduloMain.getDados();
            resultado = dados.IncluirPerfilValor(perfil, informacao.getNome(), informacao.getValor(), "S", "S", "S", "S", "");
        }
        catch (Exception ex) {
            // empty catch block
        }
        return resultado.equals("S");
    }

    public boolean associarInformacaoUsuario(String chave, String nomeInformacao, String valorInformacao) throws Exception {
        String resultado = "";
        try {
            ModControleDados dados = this.moduloMain.getDados();
            resultado = dados.IncluirUsuarioValor(chave, nomeInformacao, valorInformacao, "", "", "", "", "");
        }
        catch (Exception ex) {
            // empty catch block
        }
        return resultado.equals("S");
    }

    @Override
    public boolean verificarPerfilUsuario(String codPerfil, String loginUsuario) throws Exception {
        String resultado = "";
        try {
            ModPrincipal principal = this.moduloMain.getPrincipal();
            resultado = principal.Verif_UsuarioPerfil(codPerfil, loginUsuario);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return resultado.equals("S");
    }

    @Override
    public List<PerfilVO> getPerfis() throws Exception {
        ArrayList<PerfilVO> perfis = new ArrayList<PerfilVO>();
        ModPrincipal principal = this.moduloMain.getPrincipal();
        Vector perfisSistema = principal.PerfilSistema();
        for (Vector perfilSistema : perfisSistema) {
            PerfilVO perfil = new PerfilVO();
            perfil.setCodigo((String)perfilSistema.get(0));
            perfil.setNome((String)perfilSistema.get(1));
            perfis.add(perfil);
        }
        return perfis;
    }

    @Override
    public List<ObjetoVO> getObjetos() throws Exception {
        ArrayList<ObjetoVO> objetos = new ArrayList<ObjetoVO>();
        ModControleAcesso acesso = this.moduloMain.getCA();
        Vector arvoreObjetos = acesso.ArvoreObjetoSist();
        for (Vector objeto : arvoreObjetos) {
            ObjetoVO objetoVO = new ObjetoVO();
            objetoVO.setNome((String)objeto.get(0));
            objetos.add(objetoVO);
        }
        return objetos;
    }

    @Override
    public List<UsuarioVO> getUsuarios() throws Exception {
        ArrayList<UsuarioVO> usuarios = new ArrayList<UsuarioVO>();
        ModPrincipal principal = this.moduloMain.getPrincipal();
        Vector usuariosSistema = principal.UsuariosSistema();
        for (Vector usuario : usuariosSistema) {
            UsuarioVO usuarioVO = new UsuarioVO();
            usuarioVO.setLogin((String)usuario.get(0));
            usuarios.add(usuarioVO);
        }
        return usuarios;
    }

    @Override
    public List<InformacaoVO> getInformacoes() throws Exception {
        ArrayList<InformacaoVO> informacoes = new ArrayList<InformacaoVO>();
        ModControleDados dados = this.moduloMain.getDados();
        Vector infos = dados.InformacaoSistema();
        Iterator iterator = infos.iterator();
        InformacaoVO informacao = null;
        Iterator iteratorValor = null;
        while (iterator.hasNext()) {
            Vector info = (Vector)iterator.next();
            String nomeInfo = (String)info.get(0);
            Vector valores = dados.ValoresInformacao(nomeInfo);
            for (Vector valor : valores) {
                informacao = new InformacaoVO();
                informacao.setNome(nomeInfo);
                informacao.setValor((String)valor.get(0));
                informacoes.add(informacao);
            }
        }
        return informacoes;
    }

    @Override
    public List<UsuarioInformacaoVO> getInformacoesUsuario(UsuarioVO usuario) throws Exception {
        ArrayList<UsuarioInformacaoVO> informacoes = new ArrayList<UsuarioInformacaoVO>();
        ModControleDados dados = this.moduloMain.getDados();
        Vector infos = dados.InformacoesValoresUsuario(usuario.getLogin());
        Iterator iterator = infos.iterator();
        UsuarioInformacaoVO usuarioInformacaoVO = null;
        InformacaoVO informacao = null;
        while (iterator.hasNext()) {
            Vector info = (Vector)iterator.next();
            informacao = new InformacaoVO();
            informacao.setValor((String)info.get(0));
            informacao.setNome((String)info.get(2));
            usuarioInformacaoVO = new UsuarioInformacaoVO();
            usuarioInformacaoVO.setInformacao(informacao);
            usuarioInformacaoVO.setUsuario(usuario);
            informacoes.add(usuarioInformacaoVO);
        }
        return informacoes;
    }

    @Override
    public List<UsuarioVO> getUsuariosPerfil(PerfilVO perfil) throws Exception {
        ArrayList<UsuarioVO> usuarios = new ArrayList<UsuarioVO>();
        ModPrincipal principal = this.moduloMain.getPrincipal();
        Vector usuariosPerfil = principal.UsuariosPerfil(perfil.getCodigo());
        for (Vector usuario : usuariosPerfil) {
            UsuarioVO usuarioVO = new UsuarioVO();
            usuarioVO.setLogin((String)usuario.get(0));
            usuarios.add(usuarioVO);
        }
        return usuarios;
    }

    @Override
    public List<PerfilObjetoVO> getObjetosPerfil(PerfilVO perfil) throws Exception {
        ArrayList<PerfilObjetoVO> objetos = new ArrayList<PerfilObjetoVO>();
        ModPermissao permissao = this.moduloMain.getPermissao();
        Vector objetosPerfil = permissao.PermissoesPerfil(perfil.getCodigo(), NAO);
        Iterator iterator = objetosPerfil.iterator();
        PerfilObjetoVO perfilObjeto = null;
        ObjetoVO objetoVO = null;
        while (iterator.hasNext()) {
            Vector objeto = (Vector)iterator.next();
            String acao = (String)objeto.get(2);
            objetoVO = new ObjetoVO();
            objetoVO.setNome((String)objeto.get(0));
            perfilObjeto = new PerfilObjetoVO();
            perfilObjeto.setPerfil(perfil);
            perfilObjeto.setObjeto(objetoVO);
            if (acao == null || acao.equals("")) {
                perfilObjeto.setAcao(acao);
            }
            objetos.add(perfilObjeto);
        }
        return objetos;
    }

    @Override
    public List<PerfilVO> getPerfisUsuario(String loginUsuario) throws Exception {
        ArrayList<PerfilVO> perfis = new ArrayList<PerfilVO>();
        ModPrincipal principal = this.moduloMain.getPrincipal();
        Vector perfisUsuario = principal.PerfilUsuarioSist(loginUsuario);
        Iterator iterator = perfisUsuario.iterator();
        PerfilVO perfilVO = null;
        while (iterator.hasNext()) {
            Vector perfil = (Vector)iterator.next();
            perfilVO = new PerfilVO();
            perfilVO.setCodigo((String)perfil.get(0));
            perfilVO.setNome((String)perfil.get(1));
            perfis.add(perfilVO);
        }
        return perfis;
    }
}

