/*
 * Decompiled with CFR 0.152.
 */
package ControleAcesso;

import ControleAcesso.ChaveDeConfiguracao;
import ControleAcesso.CriptoCA;
import ControleAcesso.Main;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;

public class ModApoio
implements Serializable {
    private static final long serialVersionUID = -9190329906655281834L;
    private static final String versaoAPI = "3.10.05.19";
    private Main main;
    private static String regionalAtual;
    private static String ambienteAtual;
    private static String instanciaAtual;
    private static String ownerBD;
    private static String loginConexaoComBD;
    private static String senhaConexaoComDB;
    private static String nomeRoleConexaoComBD;
    private static String senhaRoleConexaoComBD;
    private static String nomePoolConexoes;
    private static String stringJDBC;
    private static String dominioLoginAD;
    private static String chaveLoginAD;
    private static String senhaLoginAD;
    private static String withLogOracle;
    private static Document docConfigInterfaceCA;
    private static String[] servidoresAD;
    private static String[] dominiosAD;
    private static String javaLoginAD;
    private static String urlLADP;
    private static ArrayList configuracoes;

    public ModApoio(Main main) {
        this.main = main;
    }

    private static void carregarChaveSecreta() throws Exception {
        if (configuracoes == null) {
            configuracoes = new ArrayList();
            configuracoes.add(new ChaveDeConfiguracao("instancia", "C5CFCB9B33B7CED9F638E6E346A2E3ED4970"));
            configuracoes.add(new ChaveDeConfiguracao("owner_bd", "A980788F0BE201793FBA61051B1F0502"));
            configuracoes.add(new ChaveDeConfiguracao("login_conexao_bd", "5A3E7B059AF099D3F52FFE58DFE7CCC0E253FB63BC5C2D08388D9F70DB2D4A71"));
            configuracoes.add(new ChaveDeConfiguracao("senha_conexao_bd", "8FD8CD7554AFA323F13D9EF50F6633AD498B6BA579DF9C5459330E5912180B01"));
            configuracoes.add(new ChaveDeConfiguracao("nome_role_conexao_bd", "437222F6F950A2E1AC37F00885645D64BDB08880A25BF026CFC6F7F87257EA1AB85E58BF78887803"));
            configuracoes.add(new ChaveDeConfiguracao("senha_role_conexao_bd", "EDE62DC4E573CB7B3853E3BE65E8C26087C343685C4143589B311F2FA084A57E45F46D486FC28BEE4170"));
            configuracoes.add(new ChaveDeConfiguracao("string_jdbc", "F6C5931A322046969D8F3C7C9C64BC021CF5EE0E4576"));
            configuracoes.add(new ChaveDeConfiguracao("nome_pool_conexoes", "09BD03D1D264734C5372BFE96FA59E984FC56A5C9C6610C74635DEB96D5707D300414075"));
        }
    }

    private static String descriptografar(String valorCriptografado) {
        CriptoCA cript = new CriptoCA(1);
        return cript.decriptar(valorCriptografado);
    }

    private static String criptografar(String valorDescriptografado) {
        CriptoCA cript = new CriptoCA(1);
        return cript.encriptar(valorDescriptografado);
    }

    protected static String getRegionalAtual() throws Exception {
        if (regionalAtual == null) {
            regionalAtual = ModApoio.getRegionalPadrao();
        }
        return regionalAtual;
    }

    protected static void setRegionalAtual(String regionalAtual) throws Exception {
        if (regionalAtual != null && !regionalAtual.trim().equals("")) {
            if (!ModApoio.isRegionalValida(regionalAtual)) {
                throw new Exception("A Regional informada n\u00e3o \u00e9 v\u00e1lida para o \"Arquivo de Configura\u00e7\u00e3o\" em uso.");
            }
        } else {
            throw new NullPointerException("Nenhuma Regional foi informada.");
        }
        ModApoio.regionalAtual = regionalAtual;
        ambienteAtual = null;
        instanciaAtual = null;
        ownerBD = null;
        loginConexaoComBD = null;
        senhaConexaoComDB = null;
        nomeRoleConexaoComBD = null;
        senhaRoleConexaoComBD = null;
        dominioLoginAD = null;
        chaveLoginAD = null;
        senhaLoginAD = null;
    }

    protected static String getVersaoAPI() {
        return versaoAPI;
    }

    protected static String getAmbienteAtual() throws Exception {
        if (ambienteAtual == null && instanciaAtual != null) {
            try {
                ambienteAtual = ModApoio.consultarXML("//parametro[@nome='" + ((ChaveDeConfiguracao)configuracoes.get(0)).getValorCriptografado() + "'][@valor='" + ModApoio.criptografar(instanciaAtual) + "']/parent::*/@nome").split("/")[1];
            }
            catch (NullPointerException npe) {
                throw new Exception("N\u00e3o foi poss\u00edvel encontrar o Ambiente referente \u00e0 Inst\u00e2ncia informada.", npe);
            }
        }
        return ambienteAtual;
    }

    protected static void setAmbienteAtual(String ambienteAtual) {
        ModApoio.ambienteAtual = ambienteAtual;
    }

    protected static String getInstanciaAtual() throws Exception {
        if (instanciaAtual == null && ambienteAtual != null) {
            try {
                instanciaAtual = ModApoio.descriptografar(ModApoio.consultarXML("//config[@nome='" + ModApoio.getRegionalAtual() + "/" + ModApoio.getAmbienteAtual() + "']/parametro[@nome='" + ((ChaveDeConfiguracao)configuracoes.get(0)).getValorCriptografado() + "']/@valor"));
            }
            catch (NullPointerException npe) {
                throw new Exception("N\u00e3o foi poss\u00edvel encontrar a Inst\u00e2ncia referente ao Ambiente informado.", npe);
            }
        }
        return instanciaAtual;
    }

    protected static void setInstanciaAtual(String instanciaAtual) throws Exception, NullPointerException {
        if (instanciaAtual != null && !instanciaAtual.trim().equals("")) {
            ModApoio.instanciaAtual = instanciaAtual;
            if (!ModApoio.isInstanciaValida(instanciaAtual)) {
                ModApoio.instanciaAtual = "";
                throw new SecurityException("A Inst\u00e2ncia \"" + instanciaAtual + "\" informada n\u00e3o foi encontrada no \"Arquivo de Configura\u00e7\u00e3o do Controle de Acesso\" para a Regional \"" + ModApoio.getRegionalAtual() + "\" no Ambiente \"" + ModApoio.getAmbienteAtual() + "\".");
            }
        } else {
            throw new NullPointerException("Nenhuma Inst\u00e2ncia foi informada.");
        }
    }

    private static String consultarXML(String expression) throws Exception, NullPointerException {
        try {
            ModApoio.carregarChaveSecreta();
            if (docConfigInterfaceCA == null) {
                SAXReader reader = new SAXReader();
                InputStream xmlInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("ConfigInterfaceCA.xml");
                docConfigInterfaceCA = reader.read(xmlInputStream);
            }
            String resultado = docConfigInterfaceCA.valueOf(expression);
            return resultado;
        }
        catch (DocumentException de) {
            throw new Exception("O Arquivo de Configura\u00e7\u00e3o n\u00e3o foi encontrado ou n\u00e3o est\u00e1 no mesmo formato que foi definido.", de);
        }
        catch (Exception ioe) {
            throw new Exception("Ocorreu um erro ao ler o Arquivo de Configura\u00e7\u00e3o do Controle de Acesso (ConfigInterfaceCA.xml).", ioe);
        }
    }

    protected static String getOwnerBD() throws Exception {
        if (ownerBD == null) {
            try {
                ownerBD = ModApoio.descriptografar(ModApoio.consultarXML("//config[@nome='" + ModApoio.getRegionalAtual() + "/" + ModApoio.getAmbienteAtual() + "']/parametro[@nome='" + ((ChaveDeConfiguracao)configuracoes.get(1)).getValorCriptografado() + "']/@valor"));
            }
            catch (NullPointerException npe) {
                throw new Exception("N\u00e3o foi poss\u00edvel encontrar o \"Owner de Banco de Dados\".", npe);
            }
        }
        return ownerBD;
    }

    protected static String getLoginConexaoComBD() throws Exception {
        if (loginConexaoComBD == null) {
            try {
                loginConexaoComBD = ModApoio.descriptografar(ModApoio.consultarXML("//config[@nome='" + ModApoio.getRegionalAtual() + "/" + ModApoio.getAmbienteAtual() + "']/parametro[@nome='" + ((ChaveDeConfiguracao)configuracoes.get(2)).getValorCriptografado() + "']/@valor"));
            }
            catch (NullPointerException npe) {
                throw new Exception("N\u00e3o foi poss\u00edvel encontrar o \"Login de Conex\u00e3o com o Banco de Dados\".", npe);
            }
        }
        return loginConexaoComBD;
    }

    protected static String getSenhaConexaoComBD() throws Exception {
        if (senhaConexaoComDB == null) {
            try {
                senhaConexaoComDB = ModApoio.descriptografar(ModApoio.consultarXML("//config[@nome='" + ModApoio.getRegionalAtual() + "/" + ModApoio.getAmbienteAtual() + "']/parametro[@nome='" + ((ChaveDeConfiguracao)configuracoes.get(3)).getValorCriptografado() + "']/@valor"));
            }
            catch (NullPointerException npe) {
                throw new Exception("N\u00e3o foi poss\u00edvel encontrar a \"Senha de Conex\u00e3o com o Banco de Dados\".", npe);
            }
        }
        return senhaConexaoComDB;
    }

    protected static String getNomeRoleConexaoComBD() throws Exception {
        if (nomeRoleConexaoComBD == null) {
            try {
                nomeRoleConexaoComBD = ModApoio.descriptografar(ModApoio.consultarXML("//config[@nome='" + ModApoio.getRegionalAtual() + "/" + ModApoio.getAmbienteAtual() + "']/parametro[@nome='" + ((ChaveDeConfiguracao)configuracoes.get(4)).getValorCriptografado() + "']/@valor"));
            }
            catch (NullPointerException npe) {
                throw new Exception("N\u00e3o foi poss\u00edvel encontrar o \"Nome da Role de Conex\u00e3o com o Banco de Dados\".", npe);
            }
        }
        return nomeRoleConexaoComBD;
    }

    protected static String getSenhaRoleConexaoComBD() throws Exception {
        if (senhaRoleConexaoComBD == null) {
            try {
                senhaRoleConexaoComBD = ModApoio.descriptografar(ModApoio.consultarXML("//config[@nome='" + ModApoio.getRegionalAtual() + "/" + ModApoio.getAmbienteAtual() + "']/parametro[@nome='" + ((ChaveDeConfiguracao)configuracoes.get(5)).getValorCriptografado() + "']/@valor"));
            }
            catch (NullPointerException npe) {
                throw new Exception("N\u00e3o foi poss\u00edvel encontrar a \"Senha da Role de Conex\u00e3o com o Banco de Dados\".", npe);
            }
        }
        return senhaRoleConexaoComBD;
    }

    protected static String getStringJDBC() throws Exception {
        if (stringJDBC == null) {
            try {
                stringJDBC = ModApoio.descriptografar(ModApoio.consultarXML("//config[@nome='" + ModApoio.getRegionalAtual() + "/" + ModApoio.getAmbienteAtual() + "']/parametro[@nome='" + ((ChaveDeConfiguracao)configuracoes.get(6)).getValorCriptografado() + "']/@valor"));
            }
            catch (NullPointerException npe) {
                throw new Exception("N\u00e3o foi poss\u00edvel encontrar a \"String de JDBC de Conex\u00e3o com o Banco de Dados.\".", npe);
            }
        }
        return stringJDBC;
    }

    protected static String getNomePoolConexoes() throws Exception {
        if (nomePoolConexoes == null) {
            try {
                nomePoolConexoes = ModApoio.descriptografar(ModApoio.consultarXML("//config[@nome='" + ModApoio.getRegionalAtual() + "/" + ModApoio.getAmbienteAtual() + "']/parametro[@nome='" + ((ChaveDeConfiguracao)configuracoes.get(7)).getValorCriptografado() + "']/@valor"));
            }
            catch (NullPointerException npe) {
                throw new Exception("N\u00e3o foi poss\u00edvel encontrar o \"Nome do Pool de Conex\u00f5es com o Banco de Dados.\".", npe);
            }
        }
        return nomePoolConexoes;
    }

    protected static void setNomePoolConexoes(String nomePoolConexoes) {
        ModApoio.nomePoolConexoes = nomePoolConexoes;
    }

    public static String getRegionalPadrao() throws Exception {
        try {
            return ModApoio.consultarXML("//config[@nome='GERAL']/parametro[@nome='regional_ambiente_padrao']/@valor").split("/")[0];
        }
        catch (NullPointerException npe) {
            throw new Exception("N\u00e3o foi poss\u00edvel encontrar a \"Regional Padr\u00e3o\".", npe);
        }
    }

    protected static String getAmbientePadrao() throws Exception {
        try {
            return ModApoio.consultarXML("//config[@nome='GERAL']/parametro[@nome='regional_ambiente_padrao']/@valor").split("/")[1];
        }
        catch (NullPointerException npe) {
            throw new Exception("N\u00e3o foi poss\u00edvel encontrar o \"Ambiente Padr\u00e3o\".", npe);
        }
    }

    private static boolean isRegionalValida(String codigoRegional) throws Exception {
        try {
            String regionaisValidas = ModApoio.consultarXML("//config[@nome='GERAL']/parametro[@nome='regionais_validas']/@valor");
            return regionaisValidas.indexOf(codigoRegional) > -1;
        }
        catch (Exception npe) {
            throw new Exception("N\u00e3o foi poss\u00edvel verificar se a Regional definida \u00e9 v\u00e1lida pois a configura\u00e7\u00e3o de \"Regionais V\u00e1lidas\" n\u00e3o foi encontrada.", npe);
        }
    }

    private static boolean isInstanciaValida(String codigoInstancia) {
        try {
            ModApoio.consultarXML("//parametro[@nome='" + ((ChaveDeConfiguracao)configuracoes.get(0)).getValorCriptografado() + "' and @valor='" + ModApoio.criptografar(codigoInstancia) + "']/ancestor::*[1][@nome='" + ModApoio.getRegionalAtual() + "/" + ModApoio.getAmbienteAtual() + "']/@nome");
            return true;
        }
        catch (Exception npe) {
            return false;
        }
    }

    public static boolean withLogOracle() {
        if (withLogOracle == null) {
            try {
                withLogOracle = ModApoio.consultarXML("//config[@nome='" + ModApoio.getRegionalAtual() + "/" + ModApoio.getAmbienteAtual() + "']/parametro[@nome='flag_log_oracle']/@valor");
            }
            catch (Exception npe) {
                withLogOracle = "N";
            }
        }
        return withLogOracle.equals("S");
    }

    private String consultarBD(String chaveParametro) throws Exception {
        String valorParametro = null;
        try {
            CallableStatement cstmt = this.main.getConexao().prepareCall("{? = call PKG_APOIO.FUN_CONFIG_REGIONAL(?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.setString(2, chaveParametro);
            cstmt.execute();
            valorParametro = (String)cstmt.getObject(1);
            cstmt.close();
            this.main.fecharConexaoCA();
        }
        catch (Exception e) {
            throw new SQLException("N\u00e3o foi poss\u00edvel realizar a consulta do Par\u00e2metro de Configura\u00e7\u00e3o \"" + chaveParametro + "\" informado. " + e.getMessage());
        }
        if (valorParametro != null) {
            return valorParametro;
        }
        throw new NullPointerException("O Par\u00e2metro de Configura\u00e7\u00e3o \"" + chaveParametro + "\" n\u00e3o foi encontrado.");
    }

    protected String getLinkConsole() throws Exception {
        try {
            return this.consultarBD("link_console");
        }
        catch (NullPointerException npe) {
            throw new Exception("N\u00e3o existe um \"Link para o Console do Controle de Acesso\" configurado neste Ambiente.", npe);
        }
    }

    public String getDominioLoginAD() throws Exception {
        try {
            if (dominioLoginAD == null) {
                dominioLoginAD = this.consultarBD("dominio_login_ad");
            }
            return dominioLoginAD;
        }
        catch (NullPointerException npe) {
            throw new Exception("N\u00e3o existe um \"Dom\u00ednio de Login AD\" do Controle de Acesso configurado neste Ambiente.", npe);
        }
    }

    public String getChaveLoginAD() throws Exception {
        try {
            if (chaveLoginAD == null) {
                chaveLoginAD = this.consultarBD("chave_login_ad");
            }
            return chaveLoginAD;
        }
        catch (NullPointerException npe) {
            throw new Exception("N\u00e3o existe uma \"Chave de Login AD\" do Controle de Acesso configurado neste Ambiente.", npe);
        }
    }

    public String getSenhaLoginAD() throws Exception {
        try {
            if (senhaLoginAD == null) {
                senhaLoginAD = this.consultarBD("senha_login_ad");
            }
            return senhaLoginAD;
        }
        catch (NullPointerException npe) {
            throw new Exception("N\u00e3o existe uma \"Senha de Login AD\" do Controle de Acesso configurado neste Ambiente.", npe);
        }
    }

    public String[] getServidoresAD() throws Exception {
        try {
            if (servidoresAD == null) {
                servidoresAD = this.consultarBD("lista_servidores_ad").split(";");
            }
            return servidoresAD;
        }
        catch (NullPointerException npe) {
            throw new Exception("N\u00e3o existe \"Servidor AD\" configurado neste Ambiente.", npe);
        }
    }

    public String[] getDominiosAD() throws Exception {
        try {
            if (dominiosAD == null) {
                dominiosAD = this.consultarBD("lista_dominios_ad").split(";");
            }
            return dominiosAD;
        }
        catch (NullPointerException npe) {
            throw new Exception("N\u00e3o existe \"Dom\u00ednio AD\" configurado neste Ambiente.", npe);
        }
    }

    public String getJavaLoginAD() throws Exception {
        try {
            if (javaLoginAD == null) {
                javaLoginAD = this.consultarBD("java_login_ad");
            }
            return javaLoginAD;
        }
        catch (NullPointerException npe) {
            throw new Exception("N\u00e3o existe \"Java Login AD\" configurado neste Ambiente.", npe);
        }
    }

    public String getUrlLDAP() throws Exception {
        try {
            if (urlLADP == null) {
                urlLADP = this.consultarBD("url_ldap_ad");
            }
            return urlLADP;
        }
        catch (NullPointerException npe) {
            throw new Exception("N\u00e3o existe \"URL LDAP\" configurado neste Ambiente.", npe);
        }
    }

    public String getRegiaoSistema(String codigoSistema) throws Exception {
        String regiaoSistema = null;
        try {
            CallableStatement cstmt = this.main.getConexao().prepareCall("{? = call PKG_APOIO.FUN_REGIAO_SISTEMA(?)}");
            cstmt.registerOutParameter(1, 12);
            cstmt.setString(2, codigoSistema);
            cstmt.execute();
            regiaoSistema = (String)cstmt.getObject(1);
            cstmt.close();
            this.main.fecharConexaoCA();
        }
        catch (Exception e) {
            throw new SQLException("N\u00e3o foi poss\u00edvel verificar a Regi\u00e3o relativa ao Sistema informado.\r\n" + e.getMessage());
        }
        if (regiaoSistema != null) {
            return regiaoSistema;
        }
        throw new NullPointerException("A Regi\u00e3o referente ao Sistema \"" + codigoSistema + "\" n\u00e3o foi encontrada.");
    }
}

