/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.authorization;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.authorization.usergrouprole.FindAllUserGroupRoleAuthorizationWithRoleCommand;
import br.com.petrobras.security.command.management.authorization.usergrouprole.FindAllUserGroupRoleAuthorizationWithUserGroupCommand;
import br.com.petrobras.security.command.management.authorization.usergrouprole.GrantRoleAuthorizationToUserGroupCommand;
import br.com.petrobras.security.command.management.authorization.usergrouprole.RevokeRoleAuthorizationFromUserGroupCommand;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.authorization.IUserGroupRoleAuthorizationManager;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.UserGroup;
import br.com.petrobras.security.model.authorization.access.UserGroupRoleAuthorization;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class UserGroupRoleAuthorizationManagerCoreImpl
implements IUserGroupRoleAuthorizationManager {
    public List<UserGroupRoleAuthorization> findAllWithUserGroup(UserGroup userGroup) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)userGroup);
        return this.findAllWithUserGroup(userGroup.getId());
    }

    public List<UserGroupRoleAuthorization> findAllWithUserGroup(String userGroupId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindAllUserGroupRoleAuthorizationWithUserGroupCommand cmd = ICommandIdentifier.getInstance().getFindAllUserGroupRoleAuthorizationWithUserGroupCommand();
        cmd.setUserGroupIdArg(userGroupId);
        return (List)cmd.execute();
    }

    public List<UserGroupRoleAuthorization> findAllWithRole(Role role) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        return this.findAllWithRole(role.getId());
    }

    public List<UserGroupRoleAuthorization> findAllWithRole(String roleId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindAllUserGroupRoleAuthorizationWithRoleCommand cmd = ICommandIdentifier.getInstance().getFindAllUserGroupRoleAuthorizationWithRoleCommand();
        cmd.setRoleIdArg(roleId);
        return (List)cmd.execute();
    }

    public void grant(UserGroup userGroup, Role role) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)userGroup);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        this.grant(userGroup.getId(), role.getId());
    }

    public void grant(String userGroupId, String roleId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        GrantRoleAuthorizationToUserGroupCommand cmd = ICommandIdentifier.getInstance().getGrantRoleAuthorizationToUserGroupCommand();
        cmd.setUserGroupIdArg(userGroupId);
        cmd.setRoleIdArg(roleId);
        cmd.execute();
    }

    public void revoke(UserGroup userGroup, Role role) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)userGroup);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        this.revoke(userGroup.getId(), role.getId());
    }

    public void revoke(String userGroupId, String roleId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        RevokeRoleAuthorizationFromUserGroupCommand cmd = ICommandIdentifier.getInstance().getRevokeRoleAuthorizationFromUserGroupCommand();
        cmd.setUserGroupIdArg(userGroupId);
        cmd.setRoleIdArg(roleId);
        cmd.execute();
    }
}

