/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.configuration;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.configuration.environment.FindAllEnvironmentsCommand;
import br.com.petrobras.security.command.management.configuration.environment.FindEnvironmentByIdCommand;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.management.configuration.IEnvironmentManager;
import br.com.petrobras.security.model.Environment;
import br.com.petrobras.security.model.Regional;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class EnvironmentManagerCoreImpl
implements IEnvironmentManager {
    public Environment find(String regionalId, String environmentId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindEnvironmentByIdCommand cmd = ICommandIdentifier.getInstance().getFindEnvironmentByIdCommand();
        cmd.setEnvironmentIdArg(environmentId);
        cmd.setRegionalIdArg(regionalId);
        return (Environment)cmd.execute();
    }

    public List<Environment> findAll(String regionalId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        FindAllEnvironmentsCommand cmd = ICommandIdentifier.getInstance().getFindAllEnvironmentsCommand();
        cmd.setRegionalIdArg(regionalId);
        return (List)cmd.execute();
    }

    public Environment find(Regional regional, String environmentId) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)regional);
        return this.find(regional.getId(), environmentId);
    }

    public List<Environment> findAll(Regional regional) throws PermissionDeniedException, InvalidArgumentException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)regional);
        return this.findAll(regional.getId());
    }
}

