/*
 * RegionalManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.configuration;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.configuration.IRegionalManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.model.Regional;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

public class RegionalManagerConsumerSoapImpl implements IRegionalManagerConsumer{
    
    /* [ Constantes ] */
    
    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = -6534980378197841071L;

    public ReturnMessage<List<Regional>> findAll(MessageHeader messageHeader) {
         // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject (messageHeader );

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllRegionals(smhDTO);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithRegionalListValue(srmwlvDTO);
    }

    public ReturnMessage<Regional> findById(MessageHeader messageHeader,
            String regionalId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findRegionalById(smhDTO, regionalId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithRegionalValue(rmDTO);
    }

    /* [ Dependences ] */
}

