/*
 * ResourceAuthorizationsMapMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.authorization.access.map.ResourceAuthorizationMapItem;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.ResourceAuthorizationMapItemDTO;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * Montador de mapa de autorizaes em recurso.
 * 
 * @author Phelipe Perboires - JGTL
 * @since 1.0
 * @version 1.0
 */
public class ResourceAuthorizationsMapMounter {

    /**
     * Monta um mapa de autorizaes em recurso do modelo a partir de um mapa de
     * autorizaes em recurso de transferncia.
     * 
     * @param mapDTO
     *            Mapa de autorizaes em recurso de transferncia.
     * @param preferredUserLanguage
     *            Idioma preferido do usurio.
     * @param supportedApplicationLanguages
     *            Idiomas suportados pela aplicao.
     * @return Mapa de autorizaes em recurso do modelo.
     */
    public static Map<String, ResourceAuthorizationMapItem> mountLocalObjectMap(
            List<Object> mapDTO, Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (mapDTO == null) {
            return null;
        } else {
            Map<String, ResourceAuthorizationMapItem> map = new HashMap<String, ResourceAuthorizationMapItem>();

            for (Object objectItemDTO : mapDTO) {
                ResourceAuthorizationMapItemDTO itemDTO = (ResourceAuthorizationMapItemDTO) objectItemDTO;

                if (itemDTO != null && itemDTO.getResource() != null) {
                    map.put(itemDTO.getResource().getId(),
                            ResourceAuthorizationsMapMounter
                                    .mountLocalObjectItem(itemDTO,
                                            preferredUserLanguage,
                                            supportedApplicationLanguages));
                }
            }

            return map;
        }
    }

    /**
     * Monta um item de mapa de autorizaes em recurso do modelo a partir de um
     * item de mapa de autorizaes em recurso de transferncia.
     * 
     * @param itemDTO
     *            Item de mapa de autorizaes em recurso de transferncia.
     * @param preferredUserLanguage
     *            Idioma preferido do usurio.
     * @param supportedApplicationLanguages
     *            Idiomas suportados pela aplicao.
     * @return Item de mapa de autorizaes em recurso do modelo.
     */
    public static ResourceAuthorizationMapItem mountLocalObjectItem(
            ResourceAuthorizationMapItemDTO itemDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        if (itemDTO == null) {
            return null;
        } else {
            ResourceAuthorizationMapItem item = new ResourceAuthorizationMapItem();
            item.setAuthorized(itemDTO.isAuthorized());
            item.setResource(ResourceMounter.mountLocalObject(itemDTO
                    .getResource(), preferredUserLanguage,
                    supportedApplicationLanguages));

            return item;
        }
    }

}

