 /*
 * UserGroupInformationValueAuthorizationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.authorization.information.UserGroupInformationValueAuthorization;
 import br.com.petrobras.security.model.i18n.SupportedLanguage;
 import br.com.petrobras.security.server.service.soap.UserGroupInformationValueAuthorizationDTO;

 import java.util.List;
 import java.util.Locale;

public class UserGroupInformationValueAuthorizationMounter {
    
    public static UserGroupInformationValueAuthorization mountLocalObject(
            UserGroupInformationValueAuthorizationDTO userGroupInformationValueAuthorizationDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {
        
        if (userGroupInformationValueAuthorizationDTO == null) { return null; }
        else
        {
            UserGroupInformationValueAuthorization userGroupInformationValueAuthorization = new UserGroupInformationValueAuthorization();

            userGroupInformationValueAuthorization.setUid(userGroupInformationValueAuthorizationDTO.getUid());

            userGroupInformationValueAuthorization.setUserGroup(UserGroupMounter.mountLocalObject(
                    userGroupInformationValueAuthorizationDTO.getUserGroup(), preferredUserLanguage, supportedApplicationLanguages));
            
            userGroupInformationValueAuthorization.setInformationValue(InformationValueMounter.mountLocalObject(
                    userGroupInformationValueAuthorizationDTO.getInformationValue(), preferredUserLanguage, supportedApplicationLanguages));


            return userGroupInformationValueAuthorization;
        }
    }
}
