/*
 * UserGroupRoleAuthorizationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.authorization.access.UserGroupRoleAuthorization;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.UserGroupRoleAuthorizationDTO;

import java.util.List;
import java.util.Locale;

public class UserGroupRoleAuthorizationMounter {

    public static UserGroupRoleAuthorization mountLocalObject(
            UserGroupRoleAuthorizationDTO userGroupRoleAuthorizationDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        if (userGroupRoleAuthorizationDTO == null) { return null; }
        else {
            UserGroupRoleAuthorization userGroupRoleAuthorization = new UserGroupRoleAuthorization();

            userGroupRoleAuthorization.setUid(userGroupRoleAuthorizationDTO.getUid());
            userGroupRoleAuthorization.setCreationDate(DateMounter.mountLocalObject(userGroupRoleAuthorizationDTO.getCreationDate()));

            userGroupRoleAuthorization.setUserGroup(UserGroupMounter.mountLocalObject(userGroupRoleAuthorizationDTO.getUserGroup(), preferredUserLanguage, supportedApplicationLanguages));
            userGroupRoleAuthorization.setRole(RoleMounter.mountLocalObject(userGroupRoleAuthorizationDTO.getRole(),preferredUserLanguage,supportedApplicationLanguages));


            return userGroupRoleAuthorization;
        }
    }

}
