/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.authorization;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.authorization.roleinformationvalue.FindAllRoleInfoValueAuthorizationWithInfoValueCommand;
import br.com.petrobras.security.command.management.authorization.roleinformationvalue.FindAllRoleInfoValueAuthorizationWithRoleCommand;
import br.com.petrobras.security.command.management.authorization.roleinformationvalue.GrantInformationValueAuthorizationToRoleCommand;
import br.com.petrobras.security.command.management.authorization.roleinformationvalue.GrantSharedInformationValueAuthorizationToRoleCommand;
import br.com.petrobras.security.command.management.authorization.roleinformationvalue.RevokeInformationValueAuthorizationFromRoleCommand;
import br.com.petrobras.security.command.management.authorization.roleinformationvalue.RevokeSharedInformationValueAuthorizationFromRoleCommand;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.authorization.IRoleInformationValueAuthorizationManager;
import br.com.petrobras.security.model.Application;
import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.model.Environment;
import br.com.petrobras.security.model.InformationValue;
import br.com.petrobras.security.model.Regional;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.authorization.information.RoleInformationValueAuthorization;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class RoleInformationValueAuthorizationManagerCoreImpl
implements IRoleInformationValueAuthorizationManager {
    private IUserContextIdentifier userContextIdentifier;

    public IUserContextIdentifier getUserContextIdentifier() {
        return this.userContextIdentifier;
    }

    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    public List<RoleInformationValueAuthorization> findAllWithRole(Role role) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        return this.findAllWithRole(role.getId());
    }

    public List<RoleInformationValueAuthorization> findAllWithRole(String roleId) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindAllRoleInfoValueAuthorizationWithRoleCommand cmd = ICommandIdentifier.getInstance().getFindAllRoleInfoValueAuthorizationWithRoleCommand();
        cmd.setRoleIdArg(roleId);
        return (List)cmd.execute();
    }

    public List<RoleInformationValueAuthorization> findAllWithInformationValue(InformationValue informationValue) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue.getInformation());
        ApplicationEnvironment appEnv = informationValue.getInformation().getApplicationEnvironment();
        ApplicationEnvironment currentAppEnv = this.getUserContextIdentifier().getCurrentUserContext().getConnectedApplicationEnvironment();
        if (appEnv != null && !currentAppEnv.equals((Object)appEnv)) {
            Environment informationEnvironment = appEnv.getEnvironment();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationEnvironment);
            Regional informationRegional = informationEnvironment.getRegional();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationRegional);
            Application informationApplication = appEnv.getApplication();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationApplication);
            return this.findAllWithInformationValue(informationRegional.getId(), informationApplication.getCatalogId(), informationValue.getInformation().getId(), informationValue.getId());
        }
        return this.findAllWithInformationValue(informationValue.getInformation().getId(), informationValue.getId());
    }

    public List<RoleInformationValueAuthorization> findAllWithInformationValue(String informationId, String informationValueId) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindAllRoleInfoValueAuthorizationWithInfoValueCommand cmd = ICommandIdentifier.getInstance().getFindAllRoleInfoValueAuthorizationWithInfoValueCommand();
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        return (List)cmd.execute();
    }

    public void grant(Role role, InformationValue informationValue) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue.getInformation());
        ApplicationEnvironment appEnv = informationValue.getInformation().getApplicationEnvironment();
        ApplicationEnvironment currentAppEnv = this.getUserContextIdentifier().getCurrentUserContext().getConnectedApplicationEnvironment();
        if (appEnv != null && !currentAppEnv.equals((Object)appEnv)) {
            Environment informationEnvironment = appEnv.getEnvironment();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationEnvironment);
            Regional informationRegional = informationEnvironment.getRegional();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationRegional);
            Application informationApplication = appEnv.getApplication();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationApplication);
            this.grant(role.getId(), informationRegional.getId(), informationApplication.getCatalogId(), informationValue.getInformation().getId(), informationValue.getId());
        } else {
            this.grant(role.getId(), informationValue.getInformation().getId(), informationValue.getId());
        }
    }

    public void grant(String roleId, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        GrantInformationValueAuthorizationToRoleCommand cmd = ICommandIdentifier.getInstance().getGrantInformationValueAuthorizationToRoleCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public void grant(String roleId, String regionalId, String applicationCatalogId, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        GrantSharedInformationValueAuthorizationToRoleCommand cmd = ICommandIdentifier.getInstance().getGrantSharedInformationValueAuthorizationToRoleCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public void revoke(Role role, InformationValue informationValue) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue.getInformation());
        ApplicationEnvironment appEnv = informationValue.getInformation().getApplicationEnvironment();
        ApplicationEnvironment currentAppEnv = this.getUserContextIdentifier().getCurrentUserContext().getConnectedApplicationEnvironment();
        if (appEnv != null && !currentAppEnv.equals((Object)appEnv)) {
            Environment informationEnvironment = appEnv.getEnvironment();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationEnvironment);
            Regional informationRegional = informationEnvironment.getRegional();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationRegional);
            Application informationApplication = appEnv.getApplication();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationApplication);
            this.revoke(role.getId(), informationRegional.getId(), informationApplication.getCatalogId(), informationValue.getInformation().getId(), informationValue.getId());
        } else {
            this.revoke(role.getId(), informationValue.getInformation().getId(), informationValue.getId());
        }
    }

    public void revoke(String roleId, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        RevokeInformationValueAuthorizationFromRoleCommand cmd = ICommandIdentifier.getInstance().getRevokeInformationValueAuthorizationFromRoleCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public void revoke(String roleId, String regionalId, String applicationCatalogId, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        RevokeSharedInformationValueAuthorizationFromRoleCommand cmd = ICommandIdentifier.getInstance().getRevokeSharedInformationValueAuthorizationFromRoleCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public List<RoleInformationValueAuthorization> findAllWithInformationValue(String regionalId, String applicationCatalogId, String informationId, String informationValueId) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindAllRoleInfoValueAuthorizationWithInfoValueCommand cmd = ICommandIdentifier.getInstance().getFindAllRoleInfoValueAuthorizationWithInfoValueCommand();
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        return (List)cmd.execute();
    }
}

