/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.utility;

import br.com.petrobras.security.exception.ConstraintViolationException;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.TranslationNotFoundException;
import br.com.petrobras.security.model.Application;
import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.model.Area;
import br.com.petrobras.security.model.Company;
import br.com.petrobras.security.model.EnterpriseGroup;
import br.com.petrobras.security.model.Environment;
import br.com.petrobras.security.model.ExternalUser;
import br.com.petrobras.security.model.Information;
import br.com.petrobras.security.model.InformationSharingType;
import br.com.petrobras.security.model.InformationValue;
import br.com.petrobras.security.model.Regional;
import br.com.petrobras.security.model.Resource;
import br.com.petrobras.security.model.ResourceGroup;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.UseCase;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.model.UserGroup;
import br.com.petrobras.security.model.i18n.I18nString;
import br.com.petrobras.security.model.i18n.I18nUtil;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class Validator {
    public static void throwInvalidArgumentExceptionIfNull(Object obj) {
        if (obj == null) {
            if (obj instanceof Application) {
                throw new InvalidArgumentException("Sistema n\u00e3o pode ser nulo.");
            }
            if (obj instanceof ApplicationEnvironment) {
                throw new InvalidArgumentException("Sistema-ambiente n\u00e3o pode ser nulo.");
            }
            if (obj instanceof Environment) {
                throw new InvalidArgumentException("Ambiente n\u00e3o pode ser nulo.");
            }
            if (obj instanceof Regional) {
                throw new InvalidArgumentException("Regional n\u00e3o pode ser nula.");
            }
            if (obj instanceof Resource) {
                throw new InvalidArgumentException("Recurso n\u00e3o pode ser nulo.");
            }
            if (obj instanceof Role) {
                throw new InvalidArgumentException("Papel n\u00e3o pode ser nulo.");
            }
            if (obj instanceof UseCase) {
                throw new InvalidArgumentException("Caso de uso n\u00e3o pode ser nulo.");
            }
            if (obj instanceof User) {
                throw new InvalidArgumentException("Usu\u00e1rio n\u00e3o pode ser nulo.");
            }
            if (obj instanceof UserGroup) {
                throw new InvalidArgumentException("Grupo de usu\u00e1rios n\u00e3o pode ser nulo.");
            }
            if (obj instanceof Information) {
                throw new InvalidArgumentException("Informa\u00e7\u00e3o n\u00e3o pode ser nula.");
            }
            if (obj instanceof InformationValue) {
                throw new InvalidArgumentException("Valor de informa\u00e7\u00e3o n\u00e3o pode ser nulo.");
            }
            if (obj instanceof InformationSharingType) {
                throw new InvalidArgumentException("Tipo do compartilhamento n\u00e3o pode ser nulo.");
            }
            if (obj instanceof ExternalUser) {
                throw new InvalidArgumentException("Usu\u00e1rio externo n\u00e3o pode ser nulo.");
            }
            if (obj instanceof ResourceGroup) {
                throw new InvalidArgumentException("Grupo de recurso n\u00e3o pode ser nulo.");
            }
            if (obj instanceof EnterpriseGroup) {
                throw new InvalidArgumentException("Grupo corporativo n\u00e3o pode ser nulo.");
            }
            if (obj instanceof Company) {
                throw new InvalidArgumentException("Empresa n\u00e3o pode ser nula.");
            }
            if (obj instanceof Area) {
                throw new InvalidArgumentException("\u00c1rea n\u00e3o pode ser nula.");
            }
            throw new InvalidArgumentException("Par\u00e2metro n\u00e3o pode ser nulo.");
        }
    }

    public static void throwInvalidArgumentExceptionIfIsNullOrEmpty(String str, String message) {
        if (Validator.isNullOrEmpty(str)) {
            throw new InvalidArgumentException(message);
        }
    }

    public static void throwInvalidArgumentExceptionIfIsNullOrEmpty(List<String> list, String message) {
        if (list == null || list.size() == 0) {
            throw new InvalidArgumentException(message);
        }
        for (String str : list) {
            if (!Validator.isNullOrEmpty(str)) continue;
            throw new InvalidArgumentException(message);
        }
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.trim().equals("");
    }

    public static void throwInvalidArgumentExceptionIfIsNull(Long num, String message) {
        if (num == null) {
            throw new InvalidArgumentException(message);
        }
    }

    public static void validateTranslation(I18nString translation, List<SupportedLanguage> supportedLanguages, String nomeCampo) {
        Validator.throwInvalidArgumentExceptionIfNull(translation);
        Validator.throwInvalidArgumentExceptionIfNull(supportedLanguages);
        List<String> unsupportedLanguages = Validator.getUnsupportedLanguages(translation, supportedLanguages);
        if (unsupportedLanguages.size() > 0) {
            String errorMessage = Validator.constructTranslationNotFoundErrorMessage(unsupportedLanguages, nomeCampo);
            throw new TranslationNotFoundException(errorMessage);
        }
    }

    private static List<String> getUnsupportedLanguages(I18nString translation, List<SupportedLanguage> supportedLanguages) {
        ArrayList<String> unsupportedLanguages = new ArrayList<String>();
        for (SupportedLanguage supportedLanguage : supportedLanguages) {
            Locale language = I18nUtil.convertLanguageCodeToLocale((String)supportedLanguage.getLocale().getLanguageCode());
            if (translation.hasTranslation(language) || !Validator.isNullOrEmpty(translation.get(language))) continue;
            unsupportedLanguages.add(supportedLanguage.getLocale().getLanguageCode());
        }
        return unsupportedLanguages;
    }

    private static String constructTranslationNotFoundErrorMessage(List<String> unsupportedLanguages, String nomeCampo) {
        StringBuilder sb = new StringBuilder().append("Esta aplica\u00e7\u00e3o est\u00e1 configurada para suportar mais de um idioma, ").append("por\u00e9m n\u00e3o existe tradu\u00e7\u00e3o do campo ").append(nomeCampo).append(" para o(s) idioma(s) ");
        for (int i = 0; i < unsupportedLanguages.size(); ++i) {
            if (i > 0) {
                if (i == unsupportedLanguages.size() - 1) {
                    sb.append(" e ");
                } else {
                    sb.append(", ");
                }
            }
            sb.append(unsupportedLanguages.get(i));
        }
        sb.append(".");
        return sb.toString();
    }

    public static void throwConstraintViolationExceptionIfIsNullOrEmpty(String str, String message) {
        try {
            Validator.throwInvalidArgumentExceptionIfIsNullOrEmpty(str, message);
        }
        catch (IllegalArgumentException e) {
            throw new ConstraintViolationException(message);
        }
    }

    public static void throwArgumentExceptionIfIsUnderThen(Integer minValue, Long value, String message) {
        if (value < (long)minValue.intValue()) {
            throw new InvalidArgumentException(message);
        }
    }

    public static <K> void throwInvalidArgumentExceptionIfListIsNullOrEmpty(List<K> list, String message) {
        if (list == null || list.size() == 0) {
            throw new InvalidArgumentException(message);
        }
    }
}

