package br.com.petrobras.security.consume.soap.connection;

import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.connection.IApplicationEnvironmentConnectorConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.model.security.TokenUser;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;

public class ApplicationEnvironmentConnectorConsumerSoapImpl implements IApplicationEnvironmentConnectorConsumer {

	/* (non-Javadoc)
	 * @see br.com.petrobras.security.consume.connecion.IApplicationEnvironmentConnectorConsumer#connect(java.lang.String, java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public ReturnMessage<TokenUser> connect(String ssoSessionId, String regionalId, String environmentId, String applicationCatalogId, String applicationPassword) {

		  // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .connectApplicationEnvironmentWithSSO(null, ssoSessionId, regionalId, environmentId, applicationCatalogId, applicationPassword);

        // Converte o retorno.
        ReturnMessage<TokenUser> rm = ReturnMessageMounter.mountLocalObjectWithTokenUserValue(rmDTO);

        return rm;

	}

}
