/*
 * EnvironmentManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.configuration;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.configuration.IEnvironmentManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.model.Environment;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

public class EnvironmentManagerConsumerSoapImpl implements IEnvironmentManagerConsumer {

    /* [ Constantes ] */
    
    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = -3121652105357765029L;

    public ReturnMessage<List<Environment>> findAll(
            MessageHeader messageHeader, String regionalId) {
         // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter.mountTransferObject (messageHeader );

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue srmwlvDTO = ConsumeSoapUtil.getCurrentEndPoint().findAllEnvironmentsInRegional(smhDTO,regionalId);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithEnvironmentListValue(srmwlvDTO);
    }

    public ReturnMessage<Environment> findById(MessageHeader messageHeader,
            String regionalId, String environmentId) {
        // Converte o cabealho da mensagem em um cabealho de mensagem SOAP.
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint()
                .findEnvironmentInRegionalById(smhDTO, regionalId, environmentId);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithEnvironmentValue(rmDTO);
    }



    
}

