/*
 * EnterpriseGroupOccupationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.EnterpriseGroup;
import br.com.petrobras.security.model.EnterpriseGroupOccupation;
import br.com.petrobras.security.server.service.soap.EnterpriseGroupDTO;
import br.com.petrobras.security.server.service.soap.EnterpriseGroupOccupationDTO;

import javax.xml.datatype.DatatypeConfigurationException;

/**
 * Montador da associao de cargo de empregado com grupo corporativo.
 * 
 * @author Eraldo Neto - HMGL
 * @since 3.0
 * @version 1.0
 * 
 */
public class EnterpriseGroupOccupationMounter {

    /**
     * Monta uma associao de cargo e grupo corporativo do modelo a partir de
     * uma associao de cargo e grupo corporativo de transferncia.
     * 
     * @param enterpriseGroupOccupationDTO
     *            Associao de cargo e grupo corporativo de transferncia.
     * 
     * @param enterpriseGroup
     *            Grupo corporativo
     * 
     * @return Associao de cargo e grupo corporativo do modelo.
     */
    public static EnterpriseGroupOccupation mountLocalObject(
            EnterpriseGroupOccupationDTO enterpriseGroupOccupationDTO,
            EnterpriseGroup enterpriseGroup) {
        if (enterpriseGroupOccupationDTO == null) {
            return null;
        }

        EnterpriseGroupOccupation enterpriseGroupOccupation = new EnterpriseGroupOccupation();
        enterpriseGroupOccupation.setUid(enterpriseGroupOccupationDTO.getUid());
        enterpriseGroupOccupation.setCreationDate(DateMounter.mountLocalObject(enterpriseGroupOccupationDTO.getCreationDate()));
        enterpriseGroupOccupation.setOccupation(OccupationMounter.mountLocalObject(enterpriseGroupOccupationDTO.getOccupation()));
        enterpriseGroupOccupation.setEnterpriseGroup(enterpriseGroup);


        return enterpriseGroupOccupation;
    }

    /**
     * Monta uma associao de cargo e grupo corporativo de transferncia a
     * partir de uma associao de cargo e grupo corporativo do modelo.
     * 
     * @param enterpriseGroupOccupation
     *            Associao entre cargo e grupo corporativo.
     * 
     * @param enterpriseGroup
     *            Grupo corporativo de transferncia.
     * 
     * @return Associao de cargo e grupo corporativo de transferncia.
     */
    public static EnterpriseGroupOccupationDTO mountTransferObject(
            EnterpriseGroupOccupation enterpriseGroupOccupation,
            EnterpriseGroupDTO enterpriseGroup) {
        if (enterpriseGroupOccupation == null) {
            return null;
        }

        EnterpriseGroupOccupationDTO enterpriseGroupOccupationDTO = new EnterpriseGroupOccupationDTO();
        enterpriseGroupOccupationDTO.setUid(enterpriseGroupOccupation.getUid());

        try {
            enterpriseGroupOccupationDTO.setCreationDate(DateMounter
                    .mountTransferObject(enterpriseGroupOccupation
                            .getCreationDate()));
        } catch (DatatypeConfigurationException dce) {
            enterpriseGroupOccupationDTO.setCreationDate(null);
        }

        enterpriseGroupOccupationDTO
                .setOccupation(OccupationMounter
                        .mountTransferObject(enterpriseGroupOccupation
                                .getOccupation()));
        enterpriseGroupOccupationDTO.setEnterpriseGroupId(enterpriseGroup.getId());

        return enterpriseGroupOccupationDTO;
    }
}
