 /*
 * EnterpriseGroupRoleAuthorizationMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.authorization.access.EnterpriseGroupRoleAuthorization;
 import br.com.petrobras.security.model.i18n.SupportedLanguage;
 import br.com.petrobras.security.server.service.soap.EnterpriseGroupRoleAuthorizationDTO;

 import java.util.List;
 import java.util.Locale;

/**
 * Montador de autorizao de papel para grupo corporativo.
 * 
 * @author Patrezze - YMPD
 * @since 4.2
 * @version 1.0
 *
 */
public class EnterpriseGroupRoleAuthorizationMounter {

    /**
     * Monta uma autorizao de grupo corporativo em papel a partir de uma
     * autorizao de grupo corporativo em papem de transferncia.
     * 
     * @param enterpriseGroupRoleAuthorizationDTO
     *            Autorizao de papel para grupo corporativo.
     * @param preferredUserLanguage
     *            Idioma preferido do usurio.
     * @param supportedApplicationLanguages
     *            Idiomas suportados pela aplicao.
     * @return Autorizao de grupo corporativo em papel
     */
    public static EnterpriseGroupRoleAuthorization mountLocalObject(
            EnterpriseGroupRoleAuthorizationDTO enterpriseGroupRoleAuthorizationDTO,
            Locale preferredUserLanguage,
            List<SupportedLanguage> supportedApplicationLanguages) {

        if (enterpriseGroupRoleAuthorizationDTO == null) { return null; }
        else {
            EnterpriseGroupRoleAuthorization enterpriseGroupRoleAuthorization = new EnterpriseGroupRoleAuthorization();

            enterpriseGroupRoleAuthorization.setUid(enterpriseGroupRoleAuthorizationDTO.getUid());
            enterpriseGroupRoleAuthorization.setCreationDate(DateMounter.mountLocalObject(enterpriseGroupRoleAuthorizationDTO.getCreationDate()));

            enterpriseGroupRoleAuthorization.setEnterpriseGroup(EnterpriseGroupMounter.mountLocalObject(enterpriseGroupRoleAuthorizationDTO.getEnterpriseGroup(), preferredUserLanguage, supportedApplicationLanguages));
            enterpriseGroupRoleAuthorization.setRole(RoleMounter.mountLocalObject(enterpriseGroupRoleAuthorizationDTO.getRole(),preferredUserLanguage,supportedApplicationLanguages));


            return enterpriseGroupRoleAuthorization;
        }
    }

}
