 /*
 * FunctionListMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

 import br.com.petrobras.security.model.Function;
 import br.com.petrobras.security.server.service.soap.FunctionDTO;

 import java.util.ArrayList;
 import java.util.List;

/**
 * Montador de lista de funes.
 * 
 * @author Patrezze - YMPD
 * @since 4.2
 * @version 1.0
 *
 */
public class FunctionListMounter {

    /**
     * Monta uma lista funes a partir de uma lista de empresas de transferncia.
     * 
     * @param functionListDTO Lista de funes de transferncias.
     * @return Lista de empresas.
     */
    public static List<Function> mountLocalObject(List<Object> functionListDTO) {
        if (functionListDTO == null) {
            return null;
        }
        
        List<Function> functionList = new ArrayList<Function>();
        
        for (Object objectFunctionDTO : functionListDTO) {
            FunctionDTO functionDTO = (FunctionDTO) objectFunctionDTO;
            functionList.add(FunctionMounter.mountLocalObject(functionDTO));
        }
        
        return functionList;
    }
    
}
