/*
 * RoleInformationContextMounter
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.utilities.mounters;

import br.com.petrobras.security.model.Information;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.model.RoleInformationContext;
import br.com.petrobras.security.model.i18n.SupportedLanguage;
import br.com.petrobras.security.server.service.soap.RoleInformationContextDTO;

import java.util.List;
import java.util.Locale;

/**
 * Montador de contextos do tipo informao aplicveis a papel.
 */
public class RoleInformationContextMounter {

    /**
     * Monta um contexto do tipo informao aplicvel a papel a partir de um contexto DTO.
     * @param contextDTO Contexto do tipo informao DTO.
     * @param role Papel.
     * @param preferredUserLanguage Idioma preferido do usurio.
     * @param supportedApplicationLanguages Idiomas suportados pela aplicao.
     * @return Contexto do tipo informao apliccel a papel.
     */
    public static RoleInformationContext mountLocalObject(RoleInformationContextDTO contextDTO, Role role, Locale preferredUserLanguage, List<SupportedLanguage> supportedApplicationLanguages) {
        if (contextDTO == null) {
            return null;
        }

        RoleInformationContext context = new RoleInformationContext();

        context.setUid(contextDTO.getUid());
        context.setContext(InformationMounter.mountLocalObject(contextDTO.getInformation(), preferredUserLanguage, supportedApplicationLanguages));
        context.setRole(role);

        return context;
    }

    /**
     * Monta um contexto do tipo informao aplicvel a papel DTO a partir de um contexto do tipo informao.
     * @param context Contexto do tipo informao aplicvel a papel.
     * @return Contexto do tipo informao aplicvel a papel DTO.
     */
    public static RoleInformationContextDTO mountTransferObject(RoleInformationContext context) {
        if (context == null) {
            return null;
        }

        RoleInformationContextDTO contextDTO = new RoleInformationContextDTO();

        contextDTO.setUid(context.getUid());

        if (context.getContext() instanceof Information) {
            contextDTO.setInformation(InformationMounter.mountTransferObject((Information)context.getContext()));
        } else {
            throw new UnsupportedOperationException("Tipo de contexto no  suportado. Talvez seja preciso atualizar a API.");
        }

        if (context.getRole() != null) {
            contextDTO.setRoleId(context.getRole().getId());
        }

        return contextDTO;
    }
}
