/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.configuration;

import br.com.petrobras.security.configuration.SecurityConfigurer;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class WebSecurityConfigurer
extends SecurityConfigurer {
    private static Logger LOGGER = LoggerFactory.getLogger(WebSecurityConfigurer.class);
    private static final String[] SPRING_CONFIG_LOCATION = new String[]{"classpath:br/com/petrobras/security/config/spring/business.xml", "classpath:br/com/petrobras/security/config/spring/command.xml", "classpath:br/com/petrobras/security/config/spring/consume.xml", "classpath:br/com/petrobras/security/config/spring/web/context.xml"};
    private ServletContext servletContext;

    public WebSecurityConfigurer(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    protected void loadSpringApplicationContext() {
        LOGGER.info("Tentando carregar o contexto da aplica\u00e7\u00e3o do Spring usando " + XmlWebApplicationContext.class.getSimpleName() + ".");
        XmlWebApplicationContext xmlWebApplicationContext = new XmlWebApplicationContext();
        xmlWebApplicationContext.setConfigLocations(SPRING_CONFIG_LOCATION);
        xmlWebApplicationContext.setServletContext(this.servletContext);
        xmlWebApplicationContext.refresh();
        LOGGER.info("Contexto de aplica\u00e7\u00e3o do Spring carregado usando " + XmlWebApplicationContext.class.getSimpleName() + ".");
    }
}

