/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.authorization;

import br.com.petrobras.security.authorization.IResourceAuthorizer;
import br.com.petrobras.security.command.authorization.access.FindAllResourcesAuthorizedIgnoreManagerPrivilegeCommand;
import br.com.petrobras.security.command.authorization.access.FindAllResourcesAuthorizedToUserCommand;
import br.com.petrobras.security.command.authorization.access.FindAllResourcesAuthorizedToUserInApplicationCommand;
import br.com.petrobras.security.command.authorization.access.GetResourceAuthorizationsMapOfRoleCommand;
import br.com.petrobras.security.command.authorization.access.GetResourceAuthorizationsMapOfUserCommand;
import br.com.petrobras.security.command.authorization.access.VerifyUserAuthorizationInResourceCommand;
import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.model.ContextValueSet;
import br.com.petrobras.security.model.Resource;
import br.com.petrobras.security.model.authorization.access.map.ResourceAuthorizationMapItem;
import br.com.petrobras.security.model.authorization.access.map.ResourceAuthorizationTreeMapNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ResourceAuthorizerCoreImpl
implements IResourceAuthorizer {
    private static final long serialVersionUID = -8028504407500938863L;

    public List<Resource> findAll() throws PermissionDeniedException, InvalidOperationException, SecurityException {
        return this.findAllInContext(null, null, null);
    }

    public List<Resource> findAll(String userLogin) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.findAllInContext(userLogin, null, null);
    }

    public List<Resource> findAll(String userLogin, String areaId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.findAllInContext(userLogin, areaId, null);
    }

    public List<Resource> findAll(ContextValueSet contextValuesSet) throws InvalidArgumentException, PermissionDeniedException, InvalidOperationException, SecurityException {
        return this.findAllInContext(null, null, contextValuesSet);
    }

    public List<Resource> findAll(String userLogin, ContextValueSet contextValuesSet) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.findAllInContext(userLogin, null, contextValuesSet);
    }

    public List<Resource> findAll(String userLogin, String areaId, ContextValueSet contextValuesSet) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.findAllInContext(userLogin, areaId, contextValuesSet);
    }

    private List<Resource> findAllInContext(String userLogin, String areaId, ContextValueSet contextValuesSet) {
        FindAllResourcesAuthorizedToUserCommand command = ICommandIdentifier.getInstance().getFindAllResourcesAuthorizedToUserCommand();
        command.setUserLoginArg(userLogin);
        command.setTargetAreaIdArg(areaId);
        command.setContextValueSetArg(contextValuesSet);
        if (contextValuesSet != null) {
            command.setConsiderContextArg(true);
        }
        return (List)command.execute();
    }

    public List<Resource> findAllInApplication() throws PermissionDeniedException, SecurityException {
        return this.findAllInApplication(null);
    }

    public List<Resource> findAllInApplication(String userLogin) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAllResourcesAuthorizedToUserInApplicationCommand command = ICommandIdentifier.getInstance().getFindAllResourcesAuthorizedToUserInApplicationCommand();
        command.setUserLoginArg(userLogin);
        return (List)command.execute();
    }

    public List<Resource> findAllIgnoreManagerPrivilege(String userLogin) {
        FindAllResourcesAuthorizedIgnoreManagerPrivilegeCommand command = ICommandIdentifier.getInstance().getFindAllResourcesAuthorizedIgnoreManagerPrivilegeCommand();
        command.setUserLoginArg(userLogin);
        return (List)command.execute();
    }

    public Map<String, ResourceAuthorizationMapItem> getMap() throws PermissionDeniedException, InvalidOperationException, SecurityException {
        return this.getMapInContext(null, null, null);
    }

    public Map<String, ResourceAuthorizationMapItem> getMap(String userLogin) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.getMapInContext(userLogin, null, null);
    }

    public Map<String, ResourceAuthorizationMapItem> getMap(String userLogin, String areaId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.getMapInContext(userLogin, areaId, null);
    }

    public Map<String, ResourceAuthorizationMapItem> getMap(ContextValueSet contextValuesSet) throws PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.getMapInContext(null, null, contextValuesSet);
    }

    public Map<String, ResourceAuthorizationMapItem> getMap(String userLogin, ContextValueSet contextValuesSet) throws PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.getMapInContext(userLogin, null, contextValuesSet);
    }

    public Map<String, ResourceAuthorizationMapItem> getMap(String userLogin, String areaId, ContextValueSet contextValuesSet) throws PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.getMapInContext(userLogin, areaId, null);
    }

    private Map<String, ResourceAuthorizationMapItem> getMapInContext(String userLogin, String areaId, ContextValueSet contextValuesSet) {
        GetResourceAuthorizationsMapOfUserCommand command = ICommandIdentifier.getInstance().getGetResourceAuthorizationsMapOfUserCommand();
        command.setUserLoginArg(userLogin);
        command.setTargetAreaIdArg(areaId);
        command.setContextValueSetArg(contextValuesSet);
        if (null != contextValuesSet) {
            command.setConsiderContextArg(true);
        }
        return (Map)command.execute();
    }

    public List<ResourceAuthorizationTreeMapNode> getTreeMap() throws InvalidOperationException, PermissionDeniedException, SecurityException {
        return this.convertToTreeMap(this.getMap());
    }

    public List<ResourceAuthorizationTreeMapNode> getTreeMap(String userLogin) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.convertToTreeMap(this.getMap(userLogin));
    }

    public List<ResourceAuthorizationTreeMapNode> getTreeMap(String userLogin, String areaId) {
        return this.convertToTreeMap(this.getMap(userLogin, areaId));
    }

    public List<ResourceAuthorizationTreeMapNode> getTreeMap(ContextValueSet contextValuesSet) throws PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.convertToTreeMap(this.getMap(contextValuesSet));
    }

    public List<ResourceAuthorizationTreeMapNode> getTreeMap(String userLogin, ContextValueSet contextValuesSet) throws PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.convertToTreeMap(this.getMap(userLogin, contextValuesSet));
    }

    public List<ResourceAuthorizationTreeMapNode> getTreeMap(String userLogin, String areaId, ContextValueSet contextValuesSet) throws PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.convertToTreeMap(this.getMap(userLogin, areaId, contextValuesSet));
    }

    public Map<String, ResourceAuthorizationMapItem> getMapOfRole(String roleId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        GetResourceAuthorizationsMapOfRoleCommand cmd = ICommandIdentifier.getInstance().getGetResourceAuthorizationsMapOfRoleCommand();
        cmd.setRoleIdArg(roleId);
        return (Map)cmd.execute();
    }

    public Map<String, ResourceAuthorizationMapItem> getMapOfRole(String roleId, String areaId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        GetResourceAuthorizationsMapOfRoleCommand cmd = ICommandIdentifier.getInstance().getGetResourceAuthorizationsMapOfRoleCommand();
        cmd.setRoleIdArg(roleId);
        cmd.setTargetAreaIdArg(areaId);
        return (Map)cmd.execute();
    }

    public List<ResourceAuthorizationTreeMapNode> getTreeMapOfRole(String roleId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.convertToTreeMap(this.getMapOfRole(roleId));
    }

    public List<ResourceAuthorizationTreeMapNode> getTreeMapOfRole(String roleId, String areaId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.convertToTreeMap(this.getMapOfRole(roleId, areaId));
    }

    private ResourceAuthorizationTreeMapNode getNode(List<ResourceAuthorizationTreeMapNode> tree, String resourceId, Map<String, ResourceAuthorizationMapItem> map, ResourceAuthorizationTreeMapNode parent) {
        if (tree == null) {
            tree = new ArrayList<ResourceAuthorizationTreeMapNode>();
        }
        ResourceAuthorizationMapItem mapItem = map.get(resourceId);
        Resource resource = mapItem.getResource();
        Boolean authorized = mapItem.isAuthorized();
        ResourceAuthorizationTreeMapNode treeNode = new ResourceAuthorizationTreeMapNode();
        if (parent != null) {
            treeNode.setParent(parent);
        }
        treeNode.setAuthorized(authorized.booleanValue());
        treeNode.setResource(resource);
        if (resource.getChildren() != null && resource.getChildren().size() > 0) {
            for (Resource resourceChild : resource.getChildren()) {
                String resourceChildId = resourceChild.getId();
                ResourceAuthorizationTreeMapNode treeNodeChild = this.getNode(tree, resourceChildId, map, treeNode);
                treeNode.getChildren().add(treeNodeChild);
            }
        }
        return treeNode;
    }

    private List<ResourceAuthorizationTreeMapNode> convertToTreeMap(Map<String, ResourceAuthorizationMapItem> map) {
        ArrayList<ResourceAuthorizationTreeMapNode> tree = new ArrayList<ResourceAuthorizationTreeMapNode>();
        for (Map.Entry<String, ResourceAuthorizationMapItem> item : map.entrySet()) {
            Resource parentResource = item.getValue().getResource().getParent();
            String resourceId = item.getValue().getResource().getId();
            if (parentResource != null) continue;
            tree.add(this.getNode(tree, resourceId, map, null));
        }
        return tree;
    }

    public boolean isAuthorized(String resourceId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        return this.isAuthorizedInContext(resourceId, null, null, null);
    }

    public boolean isAuthorized(String resourceId, String userLogin) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.isAuthorizedInContext(resourceId, userLogin, null, null);
    }

    public boolean isAuthorized(String resourceId, String userLogin, String areaId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.isAuthorizedInContext(resourceId, userLogin, areaId, null);
    }

    public boolean isAuthorized(String resourceId, ContextValueSet contextValuesSet) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        return this.isAuthorizedInContext(resourceId, null, null, contextValuesSet);
    }

    public boolean isAuthorized(String resourceId, String userLogin, String areaId, ContextValueSet contextValuesSet) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        return this.isAuthorizedInContext(resourceId, userLogin, areaId, contextValuesSet);
    }

    public boolean isAuthorized(String resourceId, String userLogin, ContextValueSet contextValuesSet) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        return this.isAuthorizedInContext(resourceId, userLogin, null, contextValuesSet);
    }

    private boolean isAuthorizedInContext(String resourceId, String userLogin, String targetAreaId, ContextValueSet contextValuesSet) {
        VerifyUserAuthorizationInResourceCommand command = ICommandIdentifier.getInstance().getVerifyUserAuthorizationInResourceCommand();
        if (null != contextValuesSet) {
            command.setConsiderContextArg(true);
        }
        command.setContextValueSetArg(contextValuesSet);
        command.setResourceIdArg(resourceId);
        command.setUserLoginArg(userLogin);
        command.setTargetAreaIdArg(targetAreaId);
        return (Boolean)command.execute();
    }
}

