/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.authorization;

import br.com.petrobras.security.authorization.IResourceGroupAuthorizer;
import br.com.petrobras.security.command.authorization.access.VerifyRoleAuthorizationInResourceGroupCommand;
import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.model.ResourceGroup;
import br.com.petrobras.security.model.Role;
import br.com.petrobras.security.utility.Validator;

public class ResourceGroupAuthorizerCoreImpl
implements IResourceGroupAuthorizer {
    public boolean isAuthorizedToRole(ResourceGroup resourceGroup, Role role) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)resourceGroup);
        Validator.throwInvalidArgumentExceptionIfNull((Object)role);
        return this.isAuthorizedToRole(resourceGroup.getId(), role.getId());
    }

    public boolean isAuthorizedToRole(String resourceGroupId, String roleId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        VerifyRoleAuthorizationInResourceGroupCommand cmd = ICommandIdentifier.getInstance().getVerifyRoleAuthorizationInResourceGroupCommand();
        cmd.setResourceGroupIdArg(resourceGroupId);
        cmd.setRoleIdArg(roleId);
        return (Boolean)cmd.execute();
    }
}

