/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.access;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.access.resourcegroupmembership.AddResourceToGroupCommand;
import br.com.petrobras.security.command.management.access.resourcegroupmembership.FindAllResourceGroupMembershipInGroupCommand;
import br.com.petrobras.security.command.management.access.resourcegroupmembership.RemoveResourceFromGroupCommand;
import br.com.petrobras.security.command.management.access.resourcegroupmembership.VerifyResourceGroupMembershipCommand;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.access.IResourceGroupMembershipManager;
import br.com.petrobras.security.model.Resource;
import br.com.petrobras.security.model.ResourceGroup;
import br.com.petrobras.security.model.ResourceGroupMembership;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class ResourceGroupMembershipManagerCoreImpl
implements IResourceGroupMembershipManager {
    public void addResourceToGroup(ResourceGroup resourceGroup, Resource resource) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)resourceGroup);
        Validator.throwInvalidArgumentExceptionIfNull((Object)resource);
        this.addResourceToGroup(resourceGroup.getId(), resource.getId());
    }

    public void addResourceToGroup(String resourceGroupId, String resourceId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        AddResourceToGroupCommand cmd = ICommandIdentifier.getInstance().getAddResourceToGroupCommand();
        cmd.setResourceGroupIdArg(resourceGroupId);
        cmd.setResourceIdArg(resourceId);
        cmd.execute();
    }

    public List<ResourceGroupMembership> findAllInResourceGroup(ResourceGroup resourceGroup) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)resourceGroup);
        return this.findAllInResourceGroup(resourceGroup.getId());
    }

    public List<ResourceGroupMembership> findAllInResourceGroup(String resourceGroupId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        FindAllResourceGroupMembershipInGroupCommand cmd = ICommandIdentifier.getInstance().getFindAllResourceGroupMembershipCommand();
        cmd.setResourceGroupIdArg(resourceGroupId);
        return (List)cmd.execute();
    }

    public boolean isMember(ResourceGroup resourceGroup, Resource resource) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)resourceGroup);
        Validator.throwInvalidArgumentExceptionIfNull((Object)resource);
        return this.isMember(resourceGroup.getId(), resource.getId());
    }

    public boolean isMember(String resourceGroupId, String resourceId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, SecurityException {
        VerifyResourceGroupMembershipCommand cmd = ICommandIdentifier.getInstance().getVerifyResourceGroupMembershipCommand();
        cmd.setResourceGroupIdArg(resourceGroupId);
        cmd.setResourceIdArg(resourceId);
        return (Boolean)cmd.execute();
    }

    public void removeResourceFromGroup(ResourceGroup resourceGroup, Resource resource) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)resourceGroup);
        Validator.throwInvalidArgumentExceptionIfNull((Object)resource);
        this.removeResourceFromGroup(resourceGroup.getId(), resource.getId());
    }

    public void removeResourceFromGroup(String resourceGroupId, String resourceId) throws InvalidArgumentException, PermissionDeniedException, ObjectNotFoundException, InvalidOperationException, SecurityException {
        RemoveResourceFromGroupCommand cmd = ICommandIdentifier.getInstance().getRemoveResourceFromGroupCommand();
        cmd.setResourceGroupIdArg(resourceGroupId);
        cmd.setResourceIdArg(resourceId);
        cmd.execute();
    }
}

