/*
 * Decompiled with CFR 0.152.
 */
package br.com.petrobras.security.core.management.authorization;

import br.com.petrobras.security.command.identification.ICommandIdentifier;
import br.com.petrobras.security.command.management.authorization.usergroupinformationvalue.FindAllUserGroupInfoValueAuthorizationWithInfoValueCommand;
import br.com.petrobras.security.command.management.authorization.usergroupinformationvalue.FindAllUserGroupInfoValueAuthorizationWithUserGroupCommand;
import br.com.petrobras.security.command.management.authorization.usergroupinformationvalue.GrantInformationValueAuthorizationToUserGroupCommand;
import br.com.petrobras.security.command.management.authorization.usergroupinformationvalue.GrantSharedInformationValueAuthorizationToUserGroupCommand;
import br.com.petrobras.security.command.management.authorization.usergroupinformationvalue.RevokeInformationValueAuthorizationFromUserGroupCommand;
import br.com.petrobras.security.command.management.authorization.usergroupinformationvalue.RevokeSharedInformationValueAuthorizationFromUserGroupCommand;
import br.com.petrobras.security.context.identification.IUserContextIdentifier;
import br.com.petrobras.security.exception.InvalidArgumentException;
import br.com.petrobras.security.exception.InvalidOperationException;
import br.com.petrobras.security.exception.ObjectNotFoundException;
import br.com.petrobras.security.exception.PermissionDeniedException;
import br.com.petrobras.security.exception.SecurityException;
import br.com.petrobras.security.management.authorization.IUserGroupInformationValueAuthorizationManager;
import br.com.petrobras.security.model.Application;
import br.com.petrobras.security.model.ApplicationEnvironment;
import br.com.petrobras.security.model.Environment;
import br.com.petrobras.security.model.InformationValue;
import br.com.petrobras.security.model.Regional;
import br.com.petrobras.security.model.UserGroup;
import br.com.petrobras.security.model.authorization.information.UserGroupInformationValueAuthorization;
import br.com.petrobras.security.utility.Validator;
import java.util.List;

public class UserGroupInformationValueAuthorizationManagerCoreImpl
implements IUserGroupInformationValueAuthorizationManager {
    private IUserContextIdentifier userContextIdentifier;

    public IUserContextIdentifier getUserContextIdentifier() {
        return this.userContextIdentifier;
    }

    public void setUserContextIdentifier(IUserContextIdentifier userContextIdentifier) {
        this.userContextIdentifier = userContextIdentifier;
    }

    public List<UserGroupInformationValueAuthorization> findAllWithUserGroup(UserGroup userGroup) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)userGroup);
        return this.findAllWithUserGroup(userGroup.getId());
    }

    public List<UserGroupInformationValueAuthorization> findAllWithUserGroup(String userGroupId) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindAllUserGroupInfoValueAuthorizationWithUserGroupCommand cmd = ICommandIdentifier.getInstance().getFindAllUserGroupInfoValueAuthorizationWithUserGroupCommand();
        cmd.setUserGroupIdArg(userGroupId);
        return (List)cmd.execute();
    }

    public List<UserGroupInformationValueAuthorization> findAllWithInformationValue(InformationValue informationValue) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue.getInformation());
        ApplicationEnvironment appEnv = informationValue.getInformation().getApplicationEnvironment();
        ApplicationEnvironment currentAppEnv = this.getUserContextIdentifier().getCurrentUserContext().getConnectedApplicationEnvironment();
        if (appEnv != null && !currentAppEnv.equals((Object)appEnv)) {
            Environment informationEnvironment = appEnv.getEnvironment();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationEnvironment);
            Regional informationRegional = informationEnvironment.getRegional();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationRegional);
            Application informationApplication = appEnv.getApplication();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationApplication);
            return this.findAllWithInformationValue(informationRegional.getId(), informationApplication.getCatalogId(), informationValue.getInformation().getId(), informationValue.getId());
        }
        return this.findAllWithInformationValue(informationValue.getInformation().getId(), informationValue.getId());
    }

    public List<UserGroupInformationValueAuthorization> findAllWithInformationValue(String informationId, String informationValueId) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindAllUserGroupInfoValueAuthorizationWithInfoValueCommand cmd = ICommandIdentifier.getInstance().getFindAllUserGroupInfoValueAuthorizationWithInfoValueCommand();
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        return (List)cmd.execute();
    }

    public void grant(UserGroup userGroup, InformationValue informationValue) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)userGroup);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue.getInformation());
        ApplicationEnvironment appEnv = informationValue.getInformation().getApplicationEnvironment();
        ApplicationEnvironment currentAppEnv = this.getUserContextIdentifier().getCurrentUserContext().getConnectedApplicationEnvironment();
        if (appEnv != null && !currentAppEnv.equals((Object)appEnv)) {
            Environment informationEnvironment = appEnv.getEnvironment();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationEnvironment);
            Regional informationRegional = informationEnvironment.getRegional();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationRegional);
            Application informationApplication = appEnv.getApplication();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationApplication);
            this.grant(userGroup.getId(), informationRegional.getId(), informationApplication.getCatalogId(), informationValue.getInformation().getId(), informationValue.getId());
        } else {
            this.grant(userGroup.getId(), informationValue.getInformation().getId(), informationValue.getId());
        }
    }

    public void grant(String userGroupId, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        GrantInformationValueAuthorizationToUserGroupCommand cmd = ICommandIdentifier.getInstance().getGrantInformationValueAuthorizationToUserGroupCommand();
        cmd.setUserGroupIdArg(userGroupId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public void grant(String userGroupId, String regionalId, String applicationCatalogId, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        GrantSharedInformationValueAuthorizationToUserGroupCommand cmd = ICommandIdentifier.getInstance().getGrantSharedInformationValueAuthorizationToUserGroupCommand();
        cmd.setUserGroupIdArg(userGroupId);
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public void revoke(UserGroup userGroup, InformationValue informationValue) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        Validator.throwInvalidArgumentExceptionIfNull((Object)userGroup);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue);
        Validator.throwInvalidArgumentExceptionIfNull((Object)informationValue.getInformation());
        ApplicationEnvironment appEnv = informationValue.getInformation().getApplicationEnvironment();
        ApplicationEnvironment currentAppEnv = this.getUserContextIdentifier().getCurrentUserContext().getConnectedApplicationEnvironment();
        if (appEnv != null && !currentAppEnv.equals((Object)appEnv)) {
            Environment informationEnvironment = appEnv.getEnvironment();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationEnvironment);
            Regional informationRegional = informationEnvironment.getRegional();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationRegional);
            Application informationApplication = appEnv.getApplication();
            Validator.throwInvalidArgumentExceptionIfNull((Object)informationApplication);
            this.revoke(userGroup.getId(), informationRegional.getId(), informationApplication.getCatalogId(), informationValue.getInformation().getId(), informationValue.getId());
        } else {
            this.revoke(userGroup.getId(), informationValue.getInformation().getId(), informationValue.getId());
        }
    }

    public void revoke(String userGroupId, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        RevokeInformationValueAuthorizationFromUserGroupCommand cmd = ICommandIdentifier.getInstance().getRevokeInformationValueAuthorizationFromUserGroupCommand();
        cmd.setUserGroupIdArg(userGroupId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public void revoke(String userGroupId, String regionalId, String applicationCatalogId, String informationId, String informationValueId) throws PermissionDeniedException, ObjectNotFoundException, InvalidArgumentException, InvalidOperationException, SecurityException {
        RevokeSharedInformationValueAuthorizationFromUserGroupCommand cmd = ICommandIdentifier.getInstance().getRevokeSharedInformationValueAuthorizationFromUserGroupCommand();
        cmd.setUserGroupIdArg(userGroupId);
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        cmd.execute();
    }

    public List<UserGroupInformationValueAuthorization> findAllWithInformationValue(String regionalId, String applicationCatalogId, String informationId, String informationValueId) throws InvalidArgumentException, ObjectNotFoundException, PermissionDeniedException, SecurityException {
        FindAllUserGroupInfoValueAuthorizationWithInfoValueCommand cmd = ICommandIdentifier.getInstance().getFindAllUserGroupInfoValueAuthorizationWithInfoValueCommand();
        cmd.setRegionalIdArg(regionalId);
        cmd.setApplicationCatalogIdArg(applicationCatalogId);
        cmd.setInformationIdArg(informationId);
        cmd.setInformationValueIdArg(informationValueId);
        return (List)cmd.execute();
    }
}

