/*
* @(#)UserManagerConsumerSoapImpl.java
*
*/
/*
 * UserManagerConsumerSoapImpl
 * ----------------------------------
 * Este arquivo pertence  Petrobras e no pode ser utilizado fora desta empresa sem prvia autorizao.
 * ----------------------------------
 * Esta classe segue o padro PE-1T0-00315
 */
package br.com.petrobras.security.consume.soap.management.basic;

import br.com.petrobras.security.consume.MessageHeader;
import br.com.petrobras.security.consume.ReturnMessage;
import br.com.petrobras.security.consume.management.basic.IUserManagerConsumer;
import br.com.petrobras.security.consume.soap.utilities.ConsumeSoapUtil;
import br.com.petrobras.security.consume.soap.utilities.mounters.MessageHeaderMounter;
import br.com.petrobras.security.consume.soap.utilities.mounters.ReturnMessageMounter;
import br.com.petrobras.security.model.User;
import br.com.petrobras.security.server.service.soap.SoapMessageHeader;
import br.com.petrobras.security.server.service.soap.SoapReturnMessage;
import br.com.petrobras.security.server.service.soap.SoapReturnMessageWithListValue;

import java.util.List;

/**
 * TODO Comentar.
 *
 * @author Equipe de desenvolvimento do Controle de Acesso Corporativo.
 *
 */
public class UserManagerConsumerSoapImpl implements IUserManagerConsumer {
 
    /* [ Constantes ] */
    
    /**
     * Constante de serializao.
     */
    private static final long serialVersionUID = 1943990660458194333L;

    /* [ Constantes ] */
    
    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IUserManagerConsumer#findAll(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<User>> findAll(MessageHeader messageHeader) {
        SoapMessageHeader smhDTO = MessageHeaderMounter
        .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint()
                .findAllUsers(smhDTO);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUserListValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IUserManagerConsumer#findAllInApplicationEnvironment(br.com.petrobras.security.consume.MessageHeader)
     */
    public ReturnMessage<List<User>> findAllInApplicationEnvironment(MessageHeader messageHeader) {
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil
                .getCurrentEndPoint()
                .findAllUsersInApplicationEnvironment(smhDTO);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUserListValue(rmDTO);
    }

    /* (non-Javadoc)
     * @see br.com.petrobras.security.consume.management.basic.IUserManagerConsumer#findByLogin(br.com.petrobras.security.consume.MessageHeader, java.lang.String)
     */
    public ReturnMessage<List<User>> findByLogin(MessageHeader messageHeader, List<String> usersLogins) {
        SoapMessageHeader smhDTO = MessageHeaderMounter
        .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessageWithListValue rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findUserCaByLogins(smhDTO, usersLogins);
        
        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUserListValue(rmDTO);
    }

    public ReturnMessage<User> findByLogin(MessageHeader messageHeader, String userLogin) {
        SoapMessageHeader smhDTO = MessageHeaderMounter
                .mountTransferObject(messageHeader);

        // Executa o servio SOAP.
        SoapReturnMessage rmDTO = ConsumeSoapUtil.getCurrentEndPoint().findUserCaByLogin(smhDTO, userLogin);

        // Converte o retorno.
        return ReturnMessageMounter.mountLocalObjectWithUserValue(rmDTO);
    }
}

